/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import mcjty.lostcities.worldgen.lost.regassets.StyleRE;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.PaletteSelector;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import org.apache.commons.lang3.tuple.Pair;

public class Style
implements ILostCityAsset {
    private final ResourceLocation name;
    private final List<List<Pair<Float, String>>> randomPaletteChoices = new ArrayList<List<Pair<Float, String>>>();

    public Style(StyleRE object) {
        this.name = object.getRegistryName();
        for (List<PaletteSelector> array : object.getRandomPaletteChoices()) {
            ArrayList<Pair> palettes = new ArrayList<Pair>();
            for (PaletteSelector selector : array) {
                float factor = selector.factor();
                String palette = selector.palette();
                palettes.add(Pair.of((Object)Float.valueOf(factor), (Object)palette));
            }
            this.randomPaletteChoices.add(palettes);
        }
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    public Palette getRandomPalette(IDimensionInfo provider, Random random) {
        Palette palette = new Palette("__random__");
        for (List<Pair<Float, String>> pairs : this.randomPaletteChoices) {
            float totalweight = 0.0f;
            for (Pair<Float, String> pair : pairs) {
                totalweight += ((Float)pair.getKey()).floatValue();
            }
            float r = random.nextFloat() * totalweight;
            Palette tomerge = null;
            for (Pair<Float, String> pair : pairs) {
                if (!((r -= ((Float)pair.getKey()).floatValue()) <= 0.0f)) continue;
                tomerge = AssetRegistries.PALETTES.getOrThrow((CommonLevelAccessor)provider.getWorld(), (String)pair.getRight());
                break;
            }
            palette.merge(tomerge);
        }
        return palette;
    }
}

