/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.TimedCache;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CityRarityMap;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.MultiBuilding;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedCity;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedBuilding;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedStreet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class City {
    private static Map<ChunkCoord, PredefinedCity> predefinedCityMap = null;
    private static Map<ChunkCoord, PredefinedBuilding> predefinedBuildingMap = null;
    private static Map<ChunkCoord, PredefinedStreet> predefinedStreetMap = null;
    private static final Map<ResourceKey<Level>, CityRarityMap> CITY_RARITY_MAP = new HashMap<ResourceKey<Level>, CityRarityMap>();
    private static final TimedCache<ChunkCoord, CityStyle> CITY_STYLE_CACHE = new TimedCache(() -> ((ForgeConfigSpec.IntValue)Config.CACHE_CLEANUP_SECONDS).get());
    private static Map<ChunkCoord, PreDefBuildingOffset> OCCUPIED_CHUNKS_BUILDING = null;
    private static Map<ChunkCoord, PredefinedStreet> OCCUPIED_CHUNKS_STREET = null;

    public static void cleanCache() {
        predefinedCityMap = null;
        predefinedBuildingMap = null;
        predefinedStreetMap = null;
        CITY_RARITY_MAP.clear();
        CITY_STYLE_CACHE.clear();
        OCCUPIED_CHUNKS_BUILDING = null;
        OCCUPIED_CHUNKS_STREET = null;
    }

    public static CityRarityMap getCityRarityMap(ResourceKey<Level> level, long seed, double scale, double offset, double innerScale) {
        return CITY_RARITY_MAP.computeIfAbsent(level, k -> new CityRarityMap(seed, scale, offset, innerScale));
    }

    public static PredefinedCity getPredefinedCity(CommonLevelAccessor level, ChunkCoord coord) {
        AssetRegistries.loadPredefinedStuff(level);
        if (predefinedCityMap == null) {
            predefinedCityMap = new HashMap<ChunkCoord, PredefinedCity>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                predefinedCityMap.put(new ChunkCoord(city.getDimension(), city.getChunkX(), city.getChunkZ()), city);
            }
        }
        if (predefinedCityMap.isEmpty()) {
            return null;
        }
        return predefinedCityMap.get(coord);
    }

    public static PredefinedBuilding getPredefinedBuildingAtTopLeft(CommonLevelAccessor level, ChunkCoord coord) {
        City.calculateMap(level);
        return predefinedBuildingMap.get(coord);
    }

    public static PreDefBuildingOffset getPredefinedBuilding(IDimensionInfo provider, ChunkCoord coord) {
        City.calculateOccupied(provider);
        return OCCUPIED_CHUNKS_BUILDING.get(coord);
    }

    public static PredefinedStreet getPredefinedStreet(IDimensionInfo provider, ChunkCoord coord) {
        City.calculateOccupied(provider);
        return OCCUPIED_CHUNKS_STREET.get(coord);
    }

    public static boolean isChunkOccupied(IDimensionInfo provider, ChunkCoord coord) {
        City.calculateOccupied(provider);
        return OCCUPIED_CHUNKS_BUILDING.containsKey(coord) || OCCUPIED_CHUNKS_STREET.containsKey(coord);
    }

    private static void calculateOccupied(IDimensionInfo provider) {
        if (OCCUPIED_CHUNKS_BUILDING == null) {
            OCCUPIED_CHUNKS_BUILDING = new HashMap<ChunkCoord, PreDefBuildingOffset>();
            City.calculateMap((CommonLevelAccessor)provider.getWorld());
            for (Map.Entry entry : predefinedBuildingMap.entrySet()) {
                PredefinedBuilding pb = (PredefinedBuilding)entry.getValue();
                ChunkCoord root = (ChunkCoord)entry.getKey();
                if (pb.multi()) {
                    MultiBuilding building = AssetRegistries.MULTI_BUILDINGS.getOrThrow((CommonLevelAccessor)provider.getWorld(), pb.building());
                    for (int x = 0; x < building.getDimX(); ++x) {
                        for (int z = 0; z < building.getDimZ(); ++z) {
                            OCCUPIED_CHUNKS_BUILDING.put(root.offset(x, z), new PreDefBuildingOffset(pb, x, z));
                        }
                    }
                    continue;
                }
                OCCUPIED_CHUNKS_BUILDING.put(root, new PreDefBuildingOffset(pb, 0, 0));
            }
        }
        AssetRegistries.loadPredefinedStuff((CommonLevelAccessor)provider.getWorld());
        if (OCCUPIED_CHUNKS_STREET == null) {
            OCCUPIED_CHUNKS_STREET = new HashMap<ChunkCoord, PredefinedStreet>();
            for (PredefinedCity predefinedCity : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedStreet street : predefinedCity.getPredefinedStreets()) {
                    OCCUPIED_CHUNKS_STREET.put(new ChunkCoord(predefinedCity.getDimension(), predefinedCity.getChunkX() + street.relChunkX(), predefinedCity.getChunkZ() + street.relChunkZ()), street);
                }
            }
        }
    }

    private static void calculateMap(CommonLevelAccessor level) {
        AssetRegistries.loadPredefinedStuff(level);
        if (predefinedBuildingMap == null) {
            predefinedBuildingMap = new HashMap<ChunkCoord, PredefinedBuilding>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedBuilding building : city.getPredefinedBuildings()) {
                    predefinedBuildingMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + building.relChunkX(), city.getChunkZ() + building.relChunkZ()), building);
                }
            }
        }
    }

    public static PredefinedStreet getPredefinedStreet(CommonLevelAccessor level, ChunkCoord coord) {
        AssetRegistries.loadPredefinedStuff(level);
        if (predefinedStreetMap == null) {
            predefinedStreetMap = new HashMap<ChunkCoord, PredefinedStreet>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedStreet street : city.getPredefinedStreets()) {
                    predefinedStreetMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + street.relChunkX(), city.getChunkZ() + street.relChunkZ()), street);
                }
            }
        }
        if (predefinedStreetMap.isEmpty()) {
            return null;
        }
        return predefinedStreetMap.get(coord);
    }

    public static boolean isCityCenter(ChunkCoord coord, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity((CommonLevelAccessor)provider.getWorld(), coord);
        if (city != null) {
            return true;
        }
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        Random cityCenterRandom = new Random((long)chunkZ * 797003437L + (long)chunkX * 295075153L);
        if (provider.getProfile().isSpace() || provider.getProfile().isSpheres()) {
            CitySphere sphere = CitySphere.getCitySphere(coord, provider);
            if (!sphere.isEnabled()) {
                return cityCenterRandom.nextDouble() < provider.getOutsideProfile().CITY_CHANCE;
            }
            if (sphere.getCenter().chunkX() == chunkX && sphere.getCenter().chunkZ() == chunkZ) {
                return cityCenterRandom.nextDouble() < provider.getProfile().CITY_CHANCE;
            }
            return false;
        }
        return cityCenterRandom.nextDouble() < provider.getProfile().CITY_CHANCE;
    }

    public static float getCityRadius(ChunkCoord coord, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity((CommonLevelAccessor)provider.getWorld(), coord);
        if (city != null) {
            return city.getRadius();
        }
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        Random cityRadiusRandom = new Random((long)chunkZ * 100001653L + (long)chunkX * 295075153L);
        LostCityProfile profile = provider.getProfile();
        int cityRange = profile.CITY_MAXRADIUS - profile.CITY_MINRADIUS;
        if (cityRange < 1) {
            cityRange = 1;
        }
        if (profile.isSpace() || profile.isSpheres()) {
            if (CitySphere.intersectsWithCitySphere(coord, provider)) {
                return profile.CITY_MINRADIUS + cityRadiusRandom.nextInt(cityRange);
            }
            return provider.getOutsideProfile().CITY_MINRADIUS + cityRadiusRandom.nextInt(provider.getOutsideProfile().CITY_MAXRADIUS - provider.getOutsideProfile().CITY_MINRADIUS);
        }
        return profile.CITY_MINRADIUS + cityRadiusRandom.nextInt(cityRange);
    }

    public static String getCityStyleForCityCenter(ChunkCoord coord, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity((CommonLevelAccessor)provider.getWorld(), coord);
        if (city != null && city.getCityStyle() != null) {
            return city.getCityStyle();
        }
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        Random cityStyleForCenterRandom = new Random((long)chunkZ * 899809363L + (long)chunkX * 256203221L);
        return provider.getWorldStyle().getRandomCityStyle(provider, coord, cityStyleForCenterRandom);
    }

    public static CityStyle getCityStyle(ChunkCoord coord, IDimensionInfo provider, LostCityProfile profile) {
        return CITY_STYLE_CACHE.computeIfAbsent(coord, k -> City.getCityStyleInt(coord, provider, profile));
    }

    private static CityStyle getCityStyleInt(ChunkCoord coord, IDimensionInfo provider, LostCityProfile profile) {
        Pair fromList;
        ArrayList<Pair> styles = new ArrayList<Pair>();
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        Random cityStyleRandom = new Random(provider.getSeed() + (long)chunkZ * 593441843L + (long)chunkX * 217645177L);
        if (profile.CITY_CHANCE < 0.0) {
            WorldGenLevel world = provider.getWorld();
            CityRarityMap rarityMap = City.getCityRarityMap((ResourceKey<Level>)world.m_6018_().m_46472_(), world.m_7328_(), profile.CITY_PERLIN_SCALE, profile.CITY_PERLIN_OFFSET, profile.CITY_PERLIN_INNERSCALE);
            float factor = rarityMap.getCityFactor(chunkX, chunkZ);
            if (factor < profile.CITY_STYLE_THRESHOLD) {
                styles.add(Pair.of((Object)Float.valueOf(factor), (Object)profile.CITY_STYLE_ALTERNATIVE));
            } else {
                styles.add(Pair.of((Object)Float.valueOf(factor), (Object)City.getCityStyleForCityCenter(coord, provider)));
            }
        } else {
            int offset = (profile.CITY_MAXRADIUS + 15) / 16;
            for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
                for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                    float radius;
                    float sqdist;
                    ChunkCoord c = new ChunkCoord(provider.getType(), cx, cz);
                    if (!City.isCityCenter(c, provider) || !((sqdist = (float)((cx * 16 - (chunkX << 4)) * (cx * 16 - (chunkX << 4)) + (cz * 16 - (chunkZ << 4)) * (cz * 16 - (chunkZ << 4)))) < (radius = City.getCityRadius(c, provider)) * radius)) continue;
                    float dist = (float)Math.sqrt(sqdist);
                    float factor = (radius - dist) / radius;
                    if (factor < profile.CITY_STYLE_THRESHOLD) {
                        styles.add(Pair.of((Object)Float.valueOf(factor), (Object)profile.CITY_STYLE_ALTERNATIVE));
                        continue;
                    }
                    styles.add(Pair.of((Object)Float.valueOf(factor), (Object)City.getCityStyleForCityCenter(coord, provider)));
                }
            }
        }
        Object cityStyleName = styles.isEmpty() ? provider.getWorldStyle().getRandomCityStyle(provider, coord, cityStyleRandom) : ((fromList = Tools.getRandomFromList(cityStyleRandom, styles, Pair::getLeft)) == null ? null : (String)fromList.getRight());
        return AssetRegistries.CITYSTYLES.get((CommonLevelAccessor)provider.getWorld(), (String)cityStyleName);
    }

    public static float getCityFactor(ChunkCoord coord, IDimensionInfo provider, LostCityProfile profile) {
        ResourceKey<Level> type = provider.getType();
        PredefinedBuilding predefinedBuilding = City.getPredefinedBuildingAtTopLeft((CommonLevelAccessor)provider.getWorld(), coord);
        if (predefinedBuilding != null) {
            return 1.0f;
        }
        PredefinedStreet predefinedStreet = City.getPredefinedStreet((CommonLevelAccessor)provider.getWorld(), coord);
        if (predefinedStreet != null) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuildingAtTopLeft((CommonLevelAccessor)provider.getWorld(), coord.west());
        if (predefinedBuilding != null && predefinedBuilding.multi()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuildingAtTopLeft((CommonLevelAccessor)provider.getWorld(), coord.northWest());
        if (predefinedBuilding != null && predefinedBuilding.multi()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuildingAtTopLeft((CommonLevelAccessor)provider.getWorld(), coord.north());
        if (predefinedBuilding != null && predefinedBuilding.multi()) {
            return 1.0f;
        }
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        float factor = 0.0f;
        if (profile.CITY_CHANCE < 0.0) {
            CityRarityMap rarityMap = City.getCityRarityMap(provider.dimension(), provider.getSeed(), profile.CITY_PERLIN_SCALE, profile.CITY_PERLIN_OFFSET, profile.CITY_PERLIN_INNERSCALE);
            factor = rarityMap.getCityFactor(chunkX, chunkZ);
        } else {
            int offset = (profile.CITY_MAXRADIUS + 15) / 16;
            for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
                for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                    float radius;
                    float sqdist;
                    ChunkCoord c = new ChunkCoord(type, cx, cz);
                    LostCityProfile pro = BuildingInfo.getProfile(c, provider);
                    if (pro != profile || !City.isCityCenter(c, provider) || !((sqdist = (float)((cx * 16 - (chunkX << 4)) * (cx * 16 - (chunkX << 4)) + (cz * 16 - (chunkZ << 4)) * (cz * 16 - (chunkZ << 4)))) < (radius = City.getCityRadius(c, provider)) * radius)) continue;
                    float dist = (float)Math.sqrt(sqdist);
                    factor += (radius - dist) / radius;
                }
            }
        }
        if ((double)factor > 1.0E-4 && provider.getWorld() != null) {
            ChunkHeightmap heightmap = provider.getHeightmap(coord);
            if (heightmap == null) {
                return 0.0f;
            }
            if (heightmap.getHeight() < profile.CITY_MINHEIGHT) {
                return 0.0f;
            }
            if (heightmap.getHeight() > profile.CITY_MAXHEIGHT) {
                return 0.0f;
            }
        }
        if ((double)factor > 1.0E-4 && provider.getWorld() != null) {
            WorldStyle worldStyle = AssetRegistries.WORLDSTYLES.get((CommonLevelAccessor)provider.getWorld(), profile.getWorldStyle());
            float multiplier = worldStyle.getCityChanceMultiplier(provider, coord);
            factor *= multiplier;
        }
        if (profile.CITY_SPAWN_DISTANCE2 > 0) {
            double factorDist;
            float dist = (float)Math.sqrt((chunkX << 4) * (chunkX << 4) + (chunkZ << 4) * (chunkZ << 4));
            if (dist <= (float)profile.CITY_SPAWN_DISTANCE1) {
                factorDist = profile.CITY_SPAWN_MULTIPLIER1;
            } else if (dist >= (float)profile.CITY_SPAWN_DISTANCE2) {
                factorDist = profile.CITY_SPAWN_MULTIPLIER2;
            } else {
                float f = (dist - (float)profile.CITY_SPAWN_DISTANCE1) / (float)(profile.CITY_SPAWN_DISTANCE2 - profile.CITY_SPAWN_DISTANCE1);
                factorDist = profile.CITY_SPAWN_MULTIPLIER1 + (double)f * (profile.CITY_SPAWN_MULTIPLIER2 - profile.CITY_SPAWN_MULTIPLIER1);
            }
            factor *= (float)factorDist;
        }
        return Math.min(Math.max(factor, 0.0f), 1.0f);
    }

    record PreDefBuildingOffset(PredefinedBuilding building, int offsetX, int offsetZ) {
    }
}

