/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StructureVoidBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;

public class ChunkDriver {
    private LevelAccessor region;
    private ChunkAccess primer;
    private final BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private SectionCache cache;
    private int cx;
    private int cz;

    public void setPrimer(LevelAccessor region, ChunkAccess primer) {
        this.region = region;
        this.primer = primer;
        if (primer != null) {
            this.cache = new SectionCache(region, primer.m_7697_().f_45578_ << 4, primer.m_7697_().f_45579_ << 4);
            this.cx = primer.m_7697_().f_45578_;
            this.cz = primer.m_7697_().f_45579_;
        }
    }

    public void actuallyGenerate(ChunkAccess chunk) {
        BulkSectionAccess bulk = new BulkSectionAccess(this.region);
        this.cache.generate(bulk);
        bulk.close();
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = this.cache.heightmap[x][z];
                if (y <= Integer.MIN_VALUE) continue;
                chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING).m_64249_(x, y, z, bedrock);
                chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES).m_64249_(x, y, z, bedrock);
                chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR).m_64249_(x, y, z, bedrock);
                chunk.m_6005_(Heightmap.Types.WORLD_SURFACE).m_64249_(x, y, z, bedrock);
            }
        }
        this.cache.clear();
    }

    private void setBlock(BlockPos p, BlockState state) {
        if (state != null) {
            this.cache.put(p, state);
        }
    }

    private BlockState getBlockSafe(BlockPos p) {
        return this.isThisChunk(p) ? this.getBlock(p) : this.region.m_8055_(p);
    }

    private BlockState getBlock(BlockPos p) {
        BlockState state = this.cache.get(p);
        if (state == null) {
            state = this.region.m_8055_(p);
            this.cache.put(p, state);
        }
        return state;
    }

    public LevelAccessor getRegion() {
        return this.region;
    }

    public ChunkAccess getPrimer() {
        return this.primer;
    }

    public ChunkDriver current(int x, int y, int z) {
        this.current.m_122178_(x + (this.primer.m_7697_().f_45578_ << 4), y, z + (this.primer.m_7697_().f_45579_ << 4));
        return this;
    }

    public ChunkDriver currentAbsolute(BlockPos pos) {
        this.current.m_122190_((Vec3i)pos);
        return this;
    }

    public ChunkDriver currentRelative(BlockPos pos) {
        this.current(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return this;
    }

    public BlockPos getCurrentCopy() {
        return this.current.m_7949_();
    }

    public BlockPos.MutableBlockPos getCurrent() {
        return this.current;
    }

    public void incY() {
        this.current.m_142448_(this.current.m_123342_() + 1);
    }

    public void decY() {
        this.current.m_142448_(this.current.m_123342_() - 1);
    }

    public void incX() {
        this.current.m_142451_(this.current.m_123341_() + 1);
    }

    public void incZ() {
        this.current.m_142443_(this.current.m_123343_() + 1);
    }

    public int getX() {
        return this.current.m_123341_();
    }

    public int getY() {
        return this.current.m_123342_();
    }

    public int getZ() {
        return this.current.m_123343_();
    }

    public void setBlockRange(int x, int y, int z, int y2, BlockState state) {
        this.cache.putRange(x + (this.primer.m_7697_().f_45578_ << 4), z + (this.primer.m_7697_().f_45579_ << 4), y, y2 - 1, state);
    }

    public void setBlockRange(int x, int y, int z, int y2, BlockState state, Predicate<BlockState> test) {
        this.cache.putRange(x + (this.primer.m_7697_().f_45578_ << 4), z + (this.primer.m_7697_().f_45579_ << 4), y, y2 - 1, state, test);
    }

    public void setBlockRangeToAir(int x, int y, int z, int y2) {
        this.cache.putRange(x + (this.primer.m_7697_().f_45578_ << 4), z + (this.primer.m_7697_().f_45579_ << 4), y, y2 - 1, Blocks.f_50016_.m_49966_());
    }

    public void setBlockRangeToAir(int x, int y, int z, int y2, Predicate<BlockState> test) {
        this.cache.putRange(x + (this.primer.m_7697_().f_45578_ << 4), z + (this.primer.m_7697_().f_45579_ << 4), y, y2 - 1, Blocks.f_50016_.m_49966_(), test);
    }

    private boolean isThisChunk(BlockPos pos) {
        int px = pos.m_123341_() >> 4;
        int pz = pos.m_123343_() >> 4;
        return px == this.cx && pz == this.cz;
    }

    private BlockState updateAdjacent(BlockState state, Direction direction, BlockPos pos, ChunkAccess thisChunk) {
        BlockState adjacent = this.getBlockSafe(pos);
        if (adjacent.m_60734_() instanceof LadderBlock) {
            return adjacent;
        }
        BlockState newAdjacent = null;
        try {
            newAdjacent = adjacent.m_60728_(direction, state, this.region, pos, pos.m_121945_(direction));
        }
        catch (Exception e) {
            return adjacent;
        }
        if (newAdjacent != adjacent) {
            ChunkAccess chunk = this.region.m_46865_(pos);
            if (chunk == thisChunk) {
                this.setBlock(pos, newAdjacent);
            } else if (chunk.m_6415_().m_62427_(ChunkStatus.f_62326_)) {
                this.region.m_7731_(pos, newAdjacent, 2);
            }
        }
        return newAdjacent;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.m_60734_() instanceof StairBlock;
    }

    private boolean isDifferentStairs(BlockState state, BlockPos pos, Direction face) {
        BlockPos relative = pos.m_121945_(face);
        BlockState blockstate = this.getBlockSafe(relative);
        return !ChunkDriver.isBlockStairs(blockstate) || blockstate.m_61143_((Property)StairBlock.f_56841_) != state.m_61143_((Property)StairBlock.f_56841_) || blockstate.m_61143_((Property)StairBlock.f_56842_) != state.m_61143_((Property)StairBlock.f_56842_);
    }

    private StairsShape getShapeProperty(BlockState state, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        BlockPos relative = pos.m_121945_(direction);
        BlockState blockstate = this.getBlockSafe(relative);
        if (ChunkDriver.isBlockStairs(blockstate) && state.m_61143_((Property)StairBlock.f_56842_) == blockstate.m_61143_((Property)StairBlock.f_56842_) && (direction1 = (Direction)blockstate.m_61143_((Property)StairBlock.f_56841_)).m_122434_() != ((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122434_() && this.isDifferentStairs(state, pos, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockPos relativeOpposite = pos.m_121945_(direction.m_122424_());
        BlockState blockstate1 = this.getBlockSafe(relativeOpposite);
        if (ChunkDriver.isBlockStairs(blockstate1) && state.m_61143_((Property)StairBlock.f_56842_) == blockstate1.m_61143_((Property)StairBlock.f_56842_) && (direction2 = (Direction)blockstate1.m_61143_((Property)StairBlock.f_56841_)).m_122434_() != ((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122434_() && this.isDifferentStairs(state, pos, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static WallSide canAttachWall(BlockState state) {
        return ChunkDriver.canAttach(state) ? WallSide.LOW : WallSide.NONE;
    }

    private static boolean canAttach(BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        if (state.m_60815_()) {
            return true;
        }
        return !Block.m_152463_((BlockState)state);
    }

    private BlockState correct(BlockState state) {
        int cx = this.current.m_123341_();
        int cy = this.current.m_123342_();
        int cz = this.current.m_123343_();
        ChunkAccess thisChunk = this.region.m_6325_(cx >> 4, cz >> 4);
        BlockState westState = this.updateAdjacent(state, Direction.EAST, (BlockPos)this.pos.m_122178_(cx - 1, cy, cz), thisChunk);
        BlockState eastState = this.updateAdjacent(state, Direction.WEST, (BlockPos)this.pos.m_122178_(cx + 1, cy, cz), thisChunk);
        BlockState northState = this.updateAdjacent(state, Direction.SOUTH, (BlockPos)this.pos.m_122178_(cx, cy, cz - 1), thisChunk);
        BlockState southState = this.updateAdjacent(state, Direction.NORTH, (BlockPos)this.pos.m_122178_(cx, cy, cz + 1), thisChunk);
        if (state.m_60734_() instanceof CrossCollisionBlock) {
            state = (BlockState)state.m_61124_((Property)CrossCollisionBlock.f_52312_, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(westState)));
            state = (BlockState)state.m_61124_((Property)CrossCollisionBlock.f_52310_, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(eastState)));
            state = (BlockState)state.m_61124_((Property)CrossCollisionBlock.f_52309_, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(northState)));
            state = (BlockState)state.m_61124_((Property)CrossCollisionBlock.f_52311_, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(southState)));
        } else if (state.m_60734_() instanceof WallBlock) {
            state = (BlockState)state.m_61124_((Property)WallBlock.f_57953_, (Comparable)ChunkDriver.canAttachWall(westState));
            state = (BlockState)state.m_61124_((Property)WallBlock.f_57950_, (Comparable)ChunkDriver.canAttachWall(eastState));
            state = (BlockState)state.m_61124_((Property)WallBlock.f_57951_, (Comparable)ChunkDriver.canAttachWall(northState));
            state = (BlockState)state.m_61124_((Property)WallBlock.f_57952_, (Comparable)ChunkDriver.canAttachWall(southState));
        } else if (state.m_60734_() instanceof StairBlock) {
            state = (BlockState)state.m_61124_((Property)StairBlock.f_56843_, (Comparable)this.getShapeProperty(state, (BlockPos)this.pos.m_122178_(cx, cy, cz)));
        } else if (state.m_60734_() instanceof StructureVoidBlock) {
            return null;
        }
        return state;
    }

    public ChunkDriver block(BlockState c) {
        this.setBlock((BlockPos)this.current, this.correct(c));
        return this;
    }

    public ChunkDriver add(BlockState state) {
        this.setBlock((BlockPos)this.current, this.correct(state));
        this.incY();
        return this;
    }

    public BlockState getBlock() {
        return this.getBlock((BlockPos)this.current);
    }

    public BlockState getBlockDown() {
        return this.getBlock((BlockPos)this.pos.m_122178_(this.current.m_123341_(), this.current.m_123342_() - 1, this.current.m_123343_()));
    }

    public BlockState getBlockEast() {
        return this.getBlock((BlockPos)this.pos.m_122178_(this.current.m_123341_() + 1, this.current.m_123342_(), this.current.m_123343_()));
    }

    public BlockState getBlockWest() {
        return this.getBlock((BlockPos)this.pos.m_122178_(this.current.m_123341_() - 1, this.current.m_123342_(), this.current.m_123343_()));
    }

    public BlockState getBlockSouth() {
        return this.getBlock((BlockPos)this.pos.m_122178_(this.current.m_123341_(), this.current.m_123342_(), this.current.m_123343_() + 1));
    }

    public BlockState getBlockNorth() {
        return this.getBlock((BlockPos)this.pos.m_122178_(this.current.m_123341_(), this.current.m_123342_(), this.current.m_123343_() - 1));
    }

    public BlockState getBlock(int x, int y, int z) {
        return this.getBlock((BlockPos)this.pos.m_122178_(x + (this.primer.m_7697_().f_45578_ << 4), y, z + (this.primer.m_7697_().f_45579_ << 4)));
    }

    private static class SectionCache {
        private final int minY;
        private final int maxY;
        private final int cx;
        private final int cz;
        private final S[] cache;
        private final int[][] heightmap = new int[16][16];

        private SectionCache(LevelAccessor level, int cx, int cz) {
            this.minY = level.m_141937_();
            this.maxY = level.m_151558_();
            this.cx = cx;
            this.cz = cz;
            this.cache = new S[(this.maxY - this.minY) / 16];
            this.clear();
        }

        private void putRange(int x, int z, int y1, int y2, BlockState state) {
            if (state == null) {
                return;
            }
            int ystart = y1;
            int px = x & 0xF;
            int pz = z & 0xF;
            boolean isAir = state.m_60795_();
            boolean dirty = false;
            while (y1 <= y2) {
                int sectionIdx = (y1 - this.minY) / 16;
                int idx = (px << 8) + ((y1 & 0xF) << 4) + pz;
                if (this.cache[sectionIdx].section[idx] != state) {
                    dirty = true;
                    this.cache[sectionIdx].section[idx] = state;
                    if (!isAir) {
                        this.cache[sectionIdx].isEmpty = false;
                    }
                }
                ++y1;
            }
            if (dirty) {
                if (!isAir) {
                    if (this.heightmap[px][pz] < y2) {
                        this.heightmap[px][pz] = y2;
                    }
                } else {
                    this.fixHeightmapForAir(ystart, px, pz);
                }
            }
        }

        private void putRange(int x, int z, int y1, int y2, BlockState state, Predicate<BlockState> test) {
            if (state == null) {
                return;
            }
            int ystart = y1;
            int px = x & 0xF;
            int pz = z & 0xF;
            boolean isAir = state.m_60795_();
            boolean dirty = false;
            while (y1 <= y2) {
                int sectionIdx = (y1 - this.minY) / 16;
                int idx = (px << 8) + ((y1 & 0xF) << 4) + pz;
                BlockState st = this.cache[sectionIdx].section[idx];
                if (st != state && st != null && test.test(st)) {
                    dirty = true;
                    this.cache[sectionIdx].section[idx] = state;
                    if (!isAir) {
                        this.cache[sectionIdx].isEmpty = false;
                    }
                }
                ++y1;
            }
            if (dirty) {
                if (!isAir) {
                    if (this.heightmap[px][pz] < y2) {
                        this.heightmap[px][pz] = y2;
                    }
                } else {
                    this.fixHeightmapForAir(ystart, px, pz);
                }
            }
        }

        private void put(BlockPos pos, BlockState state) {
            int sectionIdx = (pos.m_123342_() - this.minY) / 16;
            int px = pos.m_123341_() & 0xF;
            int pz = pos.m_123343_() & 0xF;
            int idx = (px << 8) + ((pos.m_123342_() & 0xF) << 4) + pz;
            if (this.cache[sectionIdx].section[idx] == state) {
                return;
            }
            this.cache[sectionIdx].section[idx] = state;
            if (!state.m_60795_()) {
                this.cache[sectionIdx].isEmpty = false;
                if (this.heightmap[px][pz] < pos.m_123342_()) {
                    this.heightmap[px][pz] = pos.m_123342_();
                }
            } else {
                this.fixHeightmapForAir(pos.m_123342_(), px, pz);
            }
        }

        private void fixHeightmapForAir(int y1, int px, int pz) {
            if (this.heightmap[px][pz] >= y1) {
                for (int y = Math.max(this.heightmap[px][pz], y1); y >= this.minY; --y) {
                    int si = (y - this.minY) / 16;
                    int i = (px << 8) + ((y & 0xF) << 4) + pz;
                    BlockState st = this.cache[si].section[i];
                    if (st == null || st.m_60795_()) continue;
                    this.heightmap[px][pz] = y;
                    return;
                }
                this.heightmap[px][pz] = Integer.MIN_VALUE;
            }
        }

        @Nullable
        private BlockState get(BlockPos pos) {
            int sectionIdx = (pos.m_123342_() - this.minY) / 16;
            int idx = ((pos.m_123341_() & 0xF) << 8) + ((pos.m_123342_() & 0xF) << 4) + (pos.m_123343_() & 0xF);
            return this.cache[sectionIdx].section[idx];
        }

        private void generate(BulkSectionAccess bulk) {
            for (int si = 0; si < (this.maxY - this.minY) / 16; ++si) {
                S c = this.cache[si];
                if (c.isEmpty) continue;
                int cy = si * 16 + this.minY;
                LevelChunkSection section = bulk.m_156104_(new BlockPos(this.cx, cy, this.cz));
                if (section == null) {
                    throw new RuntimeException("This cannot happen: " + si);
                }
                int i = 0;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            BlockState state;
                            if ((state = c.section[i++]) == null) continue;
                            section.m_62991_(x, y, z, state, false);
                        }
                    }
                }
            }
        }

        private void clear() {
            for (int si = 0; si < (this.maxY - this.minY) / 16; ++si) {
                this.cache[si] = new S();
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.heightmap[x][z] = Integer.MIN_VALUE;
                }
            }
        }
    }

    private static class S {
        private final BlockState[] section = new BlockState[4096];
        private boolean isEmpty = true;

        private S() {
        }
    }
}

