/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntSupplier;

public class TimedCache<K, V> {
    private final Map<K, Entry<V>> cache = new HashMap<K, Entry<V>>();
    private final IntSupplier ttlSecondsSupplier;
    private long nextCleanupAt;

    public TimedCache(IntSupplier ttlSecondsSupplier) {
        this.ttlSecondsSupplier = ttlSecondsSupplier;
        this.nextCleanupAt = System.currentTimeMillis();
    }

    public void clear() {
        this.cache.clear();
    }

    public V get(K key) {
        long now = System.currentTimeMillis();
        Entry<V> entry = this.cache.get(key);
        if (entry == null) {
            this.maybeCleanup(now);
            return null;
        }
        if (this.isExpired(entry, now)) {
            this.cache.remove(key);
            this.maybeCleanup(now);
            return null;
        }
        entry.lastAccess = now;
        this.maybeCleanup(now);
        return entry.value;
    }

    public void put(K key, V value) {
        long now = System.currentTimeMillis();
        this.cache.put(key, new Entry<V>(value, now));
        this.maybeCleanup(now);
    }

    public V computeIfAbsent(K key, Function<K, V> supplier) {
        V value;
        long now = System.currentTimeMillis();
        Entry<V> entry = this.cache.get(key);
        if (entry != null) {
            if (this.isExpired(entry, now)) {
                this.cache.remove(key);
            } else {
                entry.lastAccess = now;
                this.maybeCleanup(now);
                return entry.value;
            }
        }
        if ((value = supplier.apply(key)) != null) {
            this.cache.put(key, new Entry<V>(value, now));
        }
        this.maybeCleanup(now);
        return value;
    }

    private boolean isExpired(Entry<V> entry, long now) {
        return now - entry.lastAccess >= this.getTtlMillis();
    }

    private void maybeCleanup(long now) {
        if (now < this.nextCleanupAt) {
            return;
        }
        this.cleanup(now);
        this.nextCleanupAt = now + this.getCleanupIntervalMillis();
    }

    private void cleanup(long now) {
        long ttlMillis = this.getTtlMillis();
        if (ttlMillis <= 0L) {
            this.cache.clear();
            return;
        }
        Iterator<Map.Entry<K, Entry<V>>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, Entry<V>> entry = iterator.next();
            if (now - entry.getValue().lastAccess < ttlMillis) continue;
            iterator.remove();
        }
    }

    private long getCleanupIntervalMillis() {
        long ttlMillis = this.getTtlMillis();
        return Math.max(1000L, ttlMillis / 2L);
    }

    private long getTtlMillis() {
        int ttlSeconds = this.ttlSecondsSupplier.getAsInt();
        if (ttlSeconds <= 0) {
            return 0L;
        }
        return (long)ttlSeconds * 1000L;
    }

    private static class Entry<V> {
        private final V value;
        private long lastAccess;

        private Entry(V value, long lastAccess) {
            this.value = value;
            this.lastAccess = lastAccess;
        }
    }
}

