/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.biome_replacer.replacer;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.werdei.biome_replacer.BiomeReplacer;
import net.werdei.biome_replacer.config.Config;
import net.werdei.biome_replacer.mixin.MultiNoiseBiomeSourceAccessor;

public class VanillaReplacer {
    private static Map<Holder<Biome>, Holder<Biome>> replacementRules;

    public static void doReplacement(Registry<Biome> biomeRegistry, Registry<LevelStem> stemRegistry) {
        VanillaReplacer.PrepareRules(biomeRegistry);
        if (replacementRules.isEmpty()) {
            BiomeReplacer.log("No rules found, not replacing anything");
            return;
        }
        for (Map.Entry levelStem : stemRegistry.m_6579_()) {
            NoiseBasedChunkGenerator generator;
            ResourceLocation levelId = ((ResourceKey)levelStem.getKey()).m_135782_();
            LevelStem level = (LevelStem)levelStem.getValue();
            ChunkGenerator chunkGenerator = level.f_63976_();
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator) || !((generator = (NoiseBasedChunkGenerator)chunkGenerator).m_62218_() instanceof MultiNoiseBiomeSource)) {
                BiomeReplacer.log("Skipping " + String.valueOf(levelId));
                continue;
            }
            MultiNoiseBiomeSourceAccessor biomeSource = (MultiNoiseBiomeSourceAccessor)generator.m_62218_();
            Climate.ParameterList parameters = (Climate.ParameterList)biomeSource.getParameters().map(p -> p, holder -> ((MultiNoiseBiomeSourceParameterList)holder.m_203334_()).m_274385_());
            ArrayList<Pair> newParameterList = new ArrayList<Pair>();
            for (Pair value : parameters.m_186850_()) {
                Holder<Biome> newBiome = VanillaReplacer.replaceIfNeeded((Holder<Biome>)((Holder)value.getSecond()));
                if (newBiome == null) continue;
                newParameterList.add(new Pair((Object)((Climate.ParameterPoint)value.getFirst()), newBiome));
            }
            biomeSource.setParameters((Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>>)Either.left((Object)new Climate.ParameterList(newParameterList)));
            BiomeReplacer.log("Successfully replaced biomes in " + String.valueOf(levelId));
        }
    }

    private static void PrepareRules(Registry<Biome> biomeRegistry) {
        replacementRules = new HashMap<Holder<Biome>, Holder<Biome>>();
        int rulesDirect = 0;
        int rulesTag = 0;
        int rulesIgnored = 0;
        for (Config.Rule rule : Config.rules) {
            try {
                Holder<Biome> newBiome;
                if (rule.from().startsWith("#")) {
                    TagKey<Biome> tagKey = VanillaReplacer.getBiomeTagKey(rule.from().substring(1));
                    newBiome = VanillaReplacer.getBiomeHolder(rule.to(), biomeRegistry);
                    for (Holder oldBiome : biomeRegistry.m_206058_(tagKey)) {
                        replacementRules.putIfAbsent((Holder<Biome>)oldBiome, newBiome);
                    }
                    ++rulesTag;
                    continue;
                }
                Holder<Biome> oldBiome = VanillaReplacer.getBiomeHolder(rule.from(), biomeRegistry);
                newBiome = VanillaReplacer.getBiomeHolder(rule.to(), biomeRegistry);
                replacementRules.put(oldBiome, newBiome);
                ++rulesDirect;
            }
            catch (Exception e) {
                BiomeReplacer.logRuleWarning(rule.line(), e.getMessage() + ", ignoring rule");
                ++rulesIgnored;
            }
        }
        BiomeReplacer.log(String.format("Loaded %d rules (%d direct, %d tag-based) and ignored %d", rulesDirect + rulesTag, rulesDirect, rulesTag, rulesIgnored));
    }

    private static Holder<Biome> getBiomeHolder(String id, Registry<Biome> registry) throws Exception {
        if (id.equals("null")) {
            return null;
        }
        ResourceKey<Biome> resourceKey = VanillaReplacer.getBiomeResourceKey(id);
        Optional holder = registry.m_203636_(resourceKey);
        if (holder.isPresent()) {
            return (Holder)holder.get();
        }
        throw new Exception(String.format("Biome '%s' does not exist", id));
    }

    private static ResourceKey<Biome> getBiomeResourceKey(String id) throws Exception {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)id);
        if (resourceLocation == null) {
            throw new Exception(String.format("Invalid biome ID '%s'", id));
        }
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)resourceLocation);
    }

    private static TagKey<Biome> getBiomeTagKey(String id) throws Exception {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)id);
        if (resourceLocation == null) {
            throw new Exception(String.format("Invalid biome tag '#%s'", id));
        }
        return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)resourceLocation);
    }

    public static Holder<Biome> replaceIfNeeded(Holder<Biome> original) {
        return replacementRules.getOrDefault(original, original);
    }
}

