/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.warden;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Warden Attacking")
@LoadFeature(module="enhancedai:warden")
public class WardenFeature
extends Feature {
    @Config
    @Label(name="Sonic Boom range multiplier", description="Multiplies max distance from target where warden can use the sonic boom. Vanilla is 15 horizontal and 20 vertical.")
    public static Double sonicBoomRangeMultiplier = 3.0;
    @Config
    @Label(name="Darkness range multiplier", description="Multiplies the distance at which the darkness effect is applied.")
    public static Double darknessRangeMultiplier = 2.0;
    @Config
    @Label(description="Multiplies the distance at which vibrations reach wardens.")
    public static Double listenRangeMultiplier = 2.0;
    @Config
    @Label(description="If enabled, will make warden have higher step height making it not need to jump.")
    public static Boolean stepUp = true;

    public WardenFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onWardenJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!(this.isEnabled() && stepUp.booleanValue() && (entity = event.getEntity()) instanceof Warden)) {
            return;
        }
        Warden warden = (Warden)entity;
        MCUtils.applyModifier((LivingEntity)warden, (Attribute)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (UUID)UUID.fromString("4be0baaf-17a5-4bad-af5a-1b1944ed0bf3"), (String)"Enhanced AI Warden Step Height", (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)true);
    }

    public static double increaseSonicBoomRange(double range) {
        if (!Feature.isEnabled(WardenFeature.class) || sonicBoomRangeMultiplier == 1.0) {
            return range;
        }
        return range * sonicBoomRangeMultiplier;
    }

    public static double increaseDarknessRange(double range) {
        if (!Feature.isEnabled(WardenFeature.class) || darknessRangeMultiplier == 1.0) {
            return range;
        }
        return range * darknessRangeMultiplier;
    }

    public static int increaseListenRange(int range) {
        if (!Feature.isEnabled(WardenFeature.class) || listenRangeMultiplier == 1.0) {
            return range;
        }
        return (int)((double)range * listenRangeMultiplier);
    }
}

