/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.riding;

import insane96mcp.enhancedai.modules.mobs.riding.SearchMountGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Riding", description="Makes mobs ride other mobs")
@LoadFeature(module="enhancedai:mobs")
public class Riding
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_MOUNTED = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_be_mounted"));
    public static final TagKey<EntityType<?>> CAN_MOUNT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_mount"));
    public static final String CAN_SEARCH_MOUNT = "enhancedai:can_search_mount";
    public static final String SUFFOCATION_WHILE_RIDING = "enhancedai:suffocation_while_riding";
    @Config(min=0.0, max=1.0)
    @Label(name="Chance to have Riding AI", description="Chance for a mob to have an AI to go and ride mobs. Use enhancedai:can_be_mounted and enhancedai:can_mount entity type tags")
    public static Difficulty ridingAiChance = new Difficulty(0.03, 0.06, 0.1);
    @Config
    @Label(name="Stop mounting if too much suffocation", description="If true, riding mobs will dismount if take too much suffocation damage.")
    public static Boolean stopMountingIfSuffocating = true;

    public Riding(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMobJoinWorld(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_MOUNT)) {
            return;
        }
        boolean canSearchMount = NBTUtils.getBooleanOrPutDefault(mob.getPersistentData(), CAN_SEARCH_MOUNT, mob.m_217043_().m_188500_() < ridingAiChance.getByDifficulty(mob.m_9236_()));
        if (!canSearchMount) {
            return;
        }
        mob.f_21346_.m_25352_(1, (Goal)new SearchMountGoal(mob));
    }

    @SubscribeEvent
    public void onDamageTaken(LivingDamageEvent event) {
        if (!(this.isEnabled() && event.getEntity() instanceof Mob && stopMountingIfSuffocating.booleanValue() && event.getSource().m_276093_(DamageTypes.f_268612_) && event.getEntity().m_20202_() != null)) {
            return;
        }
        float suffocatingDamageTaken = event.getEntity().getPersistentData().m_128457_(SUFFOCATION_WHILE_RIDING);
        if ((suffocatingDamageTaken += event.getAmount()) >= 6.0f) {
            event.getEntity().m_8127_();
            event.getEntity().getPersistentData().m_128473_(SUFFOCATION_WHILE_RIDING);
        } else {
            event.getEntity().getPersistentData().m_128350_(SUFFOCATION_WHILE_RIDING, suffocatingDamageTaken);
        }
    }
}

