/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.fisher;

import insane96mcp.enhancedai.modules.mobs.fisher.FishingTargetGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Fisher Mobs", description="Let mobs use Fishing Rods, reeling players in. Either put a Fishing Rod in main or off hand and when near enough from the target they will use it. Only mobs in enhancedai:can_be_fisher entity type tag are affected by this feature.")
@LoadFeature(module="enhancedai:mobs")
public class FisherMobs
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_FISHER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_be_fisher"));
    public static final String HAS_FISHING_ROD_BEEN_GIVEN = "enhancedai:has_fishing_rod_been_given";
    @Config(min=0.0, max=1.0)
    @Label(name="Equip Fishing Rod Chance", description="Chance for a mob in the entity type tag enhancedai:can_be_fisher to spawn with a Fishing Rod in the offhand.\nI recommend Mobs Properties Randomness to have more control over mobs equipment.")
    public static Double equipFishingRodChance = 0.07;
    @Config(min=0.0, max=1.0)
    @Label(name="Hook Hands Chance", description="Chance for a fisher mob to steal an entity item in the hands instead of reeling the player.")
    public static Double hookHandsChance = 0.4;
    @Config
    @Label(name="Reel in ticks", description="How fast will a mob reel in the grappled entity (or if the hook is on the ground).")
    public static Difficulty reelInTicks = new Difficulty(30.0, 30.0, 20.0);
    @Config
    @Label(name="Cooldown", description="How much will a mob wait before casting the bobber again. The cooldown is doubled if successfully reels in someone.")
    public static Difficulty cooldown = new Difficulty(80.0, 80.0, 60.0);
    @Config(description="The max distance mobs will use the fishing rod. Above this distance they will try to get closer.")
    public static Integer maxDistance = 24;
    @Config(description="The min distance mobs will use the fishing rod. Below this distance they will just get closer and attack melee.")
    public static Integer minDistance = 4;

    public FisherMobs(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_BE_FISHER)) {
            return;
        }
        if (!mob.getPersistentData().m_128471_(HAS_FISHING_ROD_BEEN_GIVEN) && mob.m_21206_().m_41619_() && mob.m_217043_().m_188500_() < equipFishingRodChance) {
            mob.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42523_));
        }
        mob.getPersistentData().m_128379_(HAS_FISHING_ROD_BEEN_GIVEN, true);
        mob.f_21345_.m_25352_(1, (Goal)new FishingTargetGoal(mob));
    }
}

