/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.anticheese;

import insane96mcp.enhancedai.modules.mobs.anticheese.BreakVehicleGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Anti-Cheese", description="Prevent players from abusing some game mechanics to stop mobs. Only mobs in the entity type tag enhancedai:can_use_anti_cheese will be affected by this feature.")
@LoadFeature(module="enhancedai:mobs")
public class AntiCheese
extends Feature {
    public static final TagKey<EntityType<?>> CAN_USE_ANTI_CHEESE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_use_anti_cheese"));
    @Config
    @Label(name="Prevent Boating & Minecarting", description="If true, 'Enemies' will no longer be able to be Boated and Minecarted.")
    public static Boolean preventBoating = false;
    @Config
    @Label(name="Break trapping vehicles", description="If true, 'Enemies' will break boats or minecarts if boated or minecarted.")
    public static Boolean antiBoatAndMinecart = true;

    public AntiCheese(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMount(EntityMountEvent event) {
        if (!(this.isEnabled() && event.getEntityMounting() instanceof Enemy && (event.getEntityBeingMounted() instanceof Boat || event.getEntityBeingMounted() instanceof Minecart) && event.getEntityMounting().m_6095_().m_204039_(CAN_USE_ANTI_CHEESE))) {
            return;
        }
        if (preventBoating.booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof Mob && (mob = (Mob)entity).m_6095_().m_204039_(CAN_USE_ANTI_CHEESE))) {
            return;
        }
        if (antiBoatAndMinecart.booleanValue()) {
            mob.f_21345_.m_25352_(1, (Goal)new BreakVehicleGoal(mob));
        }
    }
}

