/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.blaze;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.projectile.SmallFireball;

public class EABlazeAttackGoal
extends Goal {
    private final Blaze blaze;
    private int attackStep;
    private int attackTime;
    private int lastSeen;
    private int fireballShot = 3;
    private int timeBetweenFireballs = 6;
    private int rechargeTime = 100;
    private int chargeTime = 60;
    private int fireballsPerShot = 1;
    private int inaccuracy = -1;

    public EABlazeAttackGoal(Blaze blaze) {
        this.blaze = blaze;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public EABlazeAttackGoal setFireballShot(int fireballShot) {
        this.fireballShot = fireballShot;
        return this;
    }

    public EABlazeAttackGoal setTimeBetweenFireballs(int timeBetweenFireballs) {
        this.timeBetweenFireballs = timeBetweenFireballs;
        return this;
    }

    public EABlazeAttackGoal setRechargeTime(int rechargeTime) {
        this.rechargeTime = rechargeTime;
        return this;
    }

    public EABlazeAttackGoal setChargeTime(int chargeTime) {
        this.chargeTime = chargeTime;
        return this;
    }

    public EABlazeAttackGoal setFireballsPerShot(int fireballsPerShot) {
        this.fireballsPerShot = fireballsPerShot;
        return this;
    }

    public EABlazeAttackGoal setInaccuracy(int inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.blaze.m_5448_();
        return livingentity != null && livingentity.m_6084_() && this.blaze.m_6779_(livingentity);
    }

    public void m_8056_() {
        this.attackStep = 0;
    }

    public void m_8041_() {
        this.blaze.m_32240_(false);
        this.lastSeen = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        --this.attackTime;
        LivingEntity livingentity = this.blaze.m_5448_();
        if (livingentity == null) {
            return;
        }
        boolean hasLineOfSight = this.blaze.m_21574_().m_148306_((Entity)livingentity);
        this.lastSeen = hasLineOfSight ? 0 : ++this.lastSeen;
        double distanceSqrToTarget = this.blaze.m_20280_((Entity)livingentity);
        if (distanceSqrToTarget < 4.0) {
            if (!hasLineOfSight) {
                return;
            }
            if (this.attackTime <= 0) {
                this.attackTime = 20;
                this.blaze.m_7327_((Entity)livingentity);
            }
            this.blaze.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
        } else if (distanceSqrToTarget < this.getFollowDistance() * this.getFollowDistance() && hasLineOfSight) {
            double xDir = livingentity.m_20185_() - this.blaze.m_20185_();
            double yDir = livingentity.m_20227_(0.3) - this.blaze.m_20227_(0.5);
            double zDir = livingentity.m_20189_() - this.blaze.m_20189_();
            if (this.attackTime <= 0) {
                ++this.attackStep;
                if (this.attackStep == 1) {
                    this.attackTime = this.chargeTime;
                    this.blaze.m_32240_(true);
                } else if (this.attackStep <= this.fireballShot + 1) {
                    this.attackTime = this.timeBetweenFireballs;
                } else {
                    this.attackTime = this.rechargeTime;
                    this.attackStep = 0;
                    this.blaze.m_32240_(false);
                }
                if (this.attackStep > 1) {
                    double inaccuracy = this.inaccuracy == -1 ? Math.sqrt(Math.sqrt(distanceSqrToTarget)) * 0.5 : 0.3 * (double)this.inaccuracy;
                    if (!this.blaze.m_20067_()) {
                        this.blaze.m_9236_().m_5898_(null, 1018, this.blaze.m_20183_(), 0);
                    }
                    for (int i = 0; i < this.fireballsPerShot; ++i) {
                        SmallFireball smallfireball = new SmallFireball(this.blaze.m_9236_(), (LivingEntity)this.blaze, xDir + this.blaze.m_217043_().m_188583_() * inaccuracy, yDir, zDir + this.blaze.m_217043_().m_188583_() * inaccuracy);
                        smallfireball.m_6034_(smallfireball.m_20185_(), this.blaze.m_20227_(0.5) + 0.5, smallfireball.m_20189_());
                        this.blaze.m_9236_().m_7967_((Entity)smallfireball);
                    }
                }
            }
            this.blaze.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
        } else if (this.lastSeen < 5) {
            this.blaze.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
        }
        super.m_8037_();
    }

    private double getFollowDistance() {
        return this.blaze.m_21133_(Attributes.f_22277_);
    }
}

