/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.LocalTime;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Sniffer.class})
public abstract class AnimalPenSniffer
extends AnimalPenAnimal {
    @Unique
    private int animalPen$sniffingCooldown;
    @Unique
    private int animalPen$eggCooldown;

    protected AnimalPenSniffer(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$sniffingCooldown > 0) {
            --this.animalPen$sniffingCooldown;
            value = true;
        }
        if (this.animalPen$eggCooldown > 0) {
            --this.animalPen$eggCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("egg_cooldown", this.animalPen$eggCooldown);
        tag.m_128405_("sniff_cooldown", this.animalPen$sniffingCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$sniffingCooldown = tag.m_128451_("sniff_cooldown");
        this.animalPen$eggCooldown = tag.m_128451_("egg_cooldown");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42399_)) {
            ObjectArrayList randomItems;
            if (this.animalPen$sniffingCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$sniffingCooldown);
                return false;
            }
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_283841_);
            LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)position.m_252807_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_);
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.f_271133_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            LinkedList<ItemStack> droppedSeeds = new LinkedList<ItemStack>();
            for (int seedCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits); seedCount > 0 && !(randomItems = lootTable.m_287195_(lootParams)).isEmpty(); seedCount -= randomItems.stream().mapToInt(ItemStack::m_41613_).sum()) {
                droppedSeeds.addAll((Collection<ItemStack>)randomItems);
            }
            Utils.mergeItemStacks(droppedSeeds).forEach(seedStack -> Block.m_49840_((Level)player.m_9236_(), (BlockPos)position.m_7494_(), (ItemStack)seedStack));
            serverLevel.m_5594_(null, position, SoundEvents.f_271330_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$sniffingCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42399_, this.animalPen$animalCount);
            return true;
        }
        if (itemStack.m_150930_(Items.f_42446_)) {
            if (this.animalPen$eggCooldown > 0) {
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.f_276468_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.f_276468_);
                if (eggCount > 64) {
                    eggStack.m_41764_(64);
                    eggCount -= 64;
                } else {
                    eggStack.m_41764_(eggCount);
                    eggCount = 0;
                }
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)position.m_7494_(), (ItemStack)eggStack);
            }
            player.m_9236_().m_5594_(null, position, SoundEvents.f_279531_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.m_41720_().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.m_150930_(Items.f_42399_)) {
            ObjectArrayList randomItems;
            if (this.animalPen$sniffingCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$sniffingCooldown);
                return ItemStack.f_41583_;
            }
            LootTable lootTable = level.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_283841_);
            LootParams lootParams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)position.m_252807_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_);
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.f_271133_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            LinkedList<ItemStack> droppedSeeds = new LinkedList<ItemStack>();
            for (int seedCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits); seedCount > 0 && !(randomItems = lootTable.m_287195_(lootParams)).isEmpty(); seedCount -= randomItems.stream().mapToInt(ItemStack::m_41613_).sum()) {
                droppedSeeds.addAll((Collection<ItemStack>)randomItems);
            }
            Utils.mergeItemStacks(droppedSeeds).forEach(seedStack -> Block.m_49840_((Level)level, (BlockPos)position.m_7494_(), (ItemStack)seedStack));
            level.m_5594_(null, position, SoundEvents.f_271330_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$sniffingCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42399_, this.animalPen$animalCount);
            return ItemStack.f_41583_;
        }
        if (itemStack.m_150930_(Items.f_42446_)) {
            if (this.animalPen$eggCooldown > 0) {
                return ItemStack.f_41583_;
            }
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.f_276468_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.f_276468_);
                if (eggCount > 64) {
                    eggStack.m_41764_(64);
                    eggCount -= 64;
                } else {
                    eggStack.m_41764_(eggCount);
                    eggCount = 0;
                }
                Block.m_49840_((Level)level, (BlockPos)position.m_7494_(), (ItemStack)eggStack);
            }
            level.m_5594_(null, position, SoundEvents.f_279531_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.m_41720_().arch$registryName()));
            return ItemStack.f_41583_;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        MutableComponent component;
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (AnimalPen.config().isShowAllInteractions() || !shortLine || AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42399_, this.animalPen$animalCount) != 0) {
            component = this.animalPen$sniffingCooldown == 0 ? Component.m_237110_((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001")}).m_130940_(ChatFormatting.GREEN) : Component.m_237110_((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.sniff_cooldown"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$sniffingCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
            List<ItemStack> food = List.of(Items.f_271133_.m_7968_(), Items.f_276594_.m_7968_());
            int size = food.size();
            int index = tick / 100 % size;
            ItemStack foodItem = food.get(index);
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.f_42399_.m_7968_(), foodItem}, (Object)component));
        }
        if (AnimalPen.config().isShowAllInteractions() || !shortLine || AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount) != 0) {
            component = this.animalPen$eggCooldown == 0 ? Component.m_237110_((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001")}).m_130940_(ChatFormatting.GREEN) : Component.m_237110_((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.egg_cooldown"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$eggCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.f_42446_.m_7968_(), Items.f_276468_.m_7968_()}, (Object)component));
        }
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        int returnValue = super.animalPen$getRedStoneSignal();
        if (this.animalPen$sniffingCooldown <= 0) {
            returnValue |= 4;
        }
        if (this.animalPen$eggCooldown <= 0) {
            returnValue |= 8;
        }
        return returnValue;
    }
}

