/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.data;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.smileycorp.atlas.api.data.DataType;

public class NBTExplorer<T extends Comparable<T>> {
    private final String target;
    private final DataType<T> returnType;

    public NBTExplorer(String target, DataType<T> returnType) {
        this.target = target;
        this.returnType = returnType;
    }

    public T findValue(CompoundTag compound) throws Exception {
        String[] directory = this.target.split("\\.");
        CompoundTag nbt = compound;
        for (int i = 0; i < directory.length; ++i) {
            try {
                if (nbt instanceof CompoundTag) {
                    if (i == directory.length - 1) {
                        T value = this.returnType.readFromNBT(nbt, directory[i]);
                        if (value == null) {
                            throw new Exception("Value " + directory[i] + "is not of type " + this.returnType.getType());
                        }
                        return value;
                    }
                    nbt = nbt.m_128423_(directory[i]);
                    continue;
                }
                if (nbt instanceof ListTag) {
                    Tag nextNBT = null;
                    for (Tag tag : (ListTag)nbt) {
                        if (!(tag instanceof CompoundTag) || !((CompoundTag)tag).m_128461_("Name").equals(directory[i])) continue;
                        nextNBT = tag;
                        break;
                    }
                    if (nextNBT == null) {
                        throw new Exception("NBTList " + (Tag)nbt + " does not contain \"Name\":\"" + directory[i] + "\"");
                    }
                    nbt = nextNBT;
                    continue;
                }
                throw new Exception("Value " + directory[i] + " is not an applicable type or cannot be found as nbt is " + (Tag)nbt);
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j < directory.length; ++j) {
                    if (i == j) {
                        builder.append(">" + directory[j] + "<");
                    } else {
                        builder.append(directory[j]);
                    }
                    if (j >= directory.length - 1) continue;
                    builder.append("\\.");
                }
                throw new Exception(builder.toString() + " " + e.getMessage(), e.getCause());
            }
        }
        throw new Exception("Could not find value " + directory);
    }

    public String toString() {
        return this.target;
    }
}

