/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.smileycorp.atlas.api.client.PlanarQuadRenderer;

public class RenderingUtils {
    public static List<BakedModel> replaceRegisteredModel(Map<ResourceLocation, BakedModel> map, ResourceLocation name, Function<BakedModel, BakedModel> function) {
        ArrayList models = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, BakedModel> entry : map.entrySet()) {
            ResourceLocation loc = entry.getKey();
            if (!loc.m_135827_().equals(name.m_135827_()) || !loc.m_135815_().split("#")[0].equals(name.m_135815_())) continue;
            models.add(function.apply(entry.getValue()));
        }
        BakedModel model = function.apply(map.get(name));
        map.put(name, model);
        return models;
    }

    public static void renderCubeQuad(BufferBuilder buffer, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, Level world, int luminance, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            RenderingUtils.renderPlanarQuad(buffer, facing, x, y, z, layer, colour, texture, world, luminance, pos);
        }
    }

    public static void renderPlanarQuad(BufferBuilder buffer, Direction facing, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, Level world, int luminance, BlockPos pos) {
        Vec3[] plane = PlanarQuadRenderer.getQuadsFor(facing);
        Vec3 offset = layer == 0 ? new Vec3(0.0, 0.0, 0.0) : PlanarQuadRenderer.getOffsetFor(facing, x, y, z, layer);
        int rgba = colour.getRGB();
        for (int i = 0; i < 4; ++i) {
            Vec3 quadPos = plane[i];
            float r = (float)((rgba & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((rgba & 0xFF00) >> 8) / 255.0f;
            float b = (float)(rgba & 0xFF) / 255.0f;
            float a = (float)((rgba & 0xFF000000) >> 24) / 255.0f;
            float u = i < 2 ? texture.m_118410_() - 6.25E-6f : texture.m_118409_() + 6.25E-6f;
            float v = i == 1 || i == 2 ? texture.m_118412_() - 6.25E-6f : texture.m_118411_() + 6.25E-6f;
            buffer.m_5483_(quadPos.m_7096_() + offset.m_7096_(), quadPos.m_7098_() + offset.m_7098_(), quadPos.m_7094_() + offset.m_7094_()).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
        }
    }

    public static List<BakedQuad> getQuadsForCube(Color colour, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction facing : Direction.values()) {
            quads.addAll(RenderingUtils.getQuadsForPlane(facing, colour, sprite));
        }
        return quads;
    }

    public static List<BakedQuad> getQuadsForPlane(Direction facing, Color colour, TextureAtlasSprite sprite) {
        return RenderingUtils.getQuadsForPlane(facing, colour, sprite, 0);
    }

    public static List<BakedQuad> getQuadsForPlane(Direction facing, Color colour, TextureAtlasSprite sprite, int layer) {
        ArrayList quads = Lists.newArrayList();
        Vec3[] vecs = PlanarQuadRenderer.getQuadsFor(facing);
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(quads::add);
        builder.setSprite(sprite);
        builder.setDirection(facing);
        Vec3 normal = new Vec3(vecs[2].m_7096_() - vecs[1].m_7096_(), vecs[2].m_7098_() - vecs[1].m_7098_(), vecs[2].m_7094_() - vecs[1].m_7094_());
        normal.m_82537_(new Vec3(vecs[0].m_7096_() - vecs[1].m_7096_(), vecs[0].m_7098_() - vecs[1].m_7098_(), vecs[0].m_7094_() - vecs[1].m_7094_()));
        normal.m_82541_();
        RenderingUtils.addVertex((VertexConsumer)builder, (float)vecs[0].m_7096_(), (float)vecs[0].m_7098_(), (float)vecs[0].m_7094_(), 0.0f, 0.0f, normal, colour, sprite);
        RenderingUtils.addVertex((VertexConsumer)builder, (float)vecs[1].m_7096_(), (float)vecs[1].m_7098_(), (float)vecs[1].m_7094_(), 0.0f, sprite.m_174744_(), normal, colour, sprite);
        RenderingUtils.addVertex((VertexConsumer)builder, (float)vecs[2].m_7096_(), (float)vecs[2].m_7098_(), (float)vecs[2].m_7094_(), sprite.m_174743_(), sprite.m_174744_(), normal, colour, sprite);
        RenderingUtils.addVertex((VertexConsumer)builder, (float)vecs[3].m_7096_(), (float)vecs[3].m_7098_(), (float)vecs[3].m_7094_(), sprite.m_174743_(), 0.0f, normal, colour, sprite);
        return quads;
    }

    private static void addVertex(VertexConsumer builder, float x, float y, float z, float u, float v, Vec3 normal, Color colour, TextureAtlasSprite sprite) {
        builder.m_5483_((double)x, (double)y, (double)z).m_7421_(u, v).m_7120_(0, 0).m_6122_(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getAlpha()).m_5601_((float)normal.m_7096_(), (float)normal.m_7098_(), (float)normal.m_7094_()).m_5752_();
    }

    public static void drawText(PoseStack stack, Component text, float x, float y, int colour, boolean hasShadow) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91062_.m_272077_(text, x, y, colour, hasShadow, stack.m_85850_().m_252922_(), (MultiBufferSource)mc.m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void drawText(PoseStack stack, String text, float x, float y, int colour, boolean hasShadow) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91062_.m_271703_(text, x, y, colour, hasShadow, stack.m_85850_().m_252922_(), (MultiBufferSource)mc.m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

