/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.smileycorp.atlas.api.block.WoodBlock;

public class WoodBlockBuilder {
    protected DeferredRegister<Item> items;
    protected DeferredRegister<Block> blocks;
    protected final String name;
    protected final String modid;
    protected final Supplier<CreativeModeTab> tab;
    protected Supplier<CreativeModeTab> decorations_tab;
    protected MapColor plank_colour = MapColor.f_283825_;
    protected MapColor bark_colour = MapColor.f_283819_;
    protected MapColor leaves_colour = MapColor.f_283824_;
    protected AbstractTreeGrower tree_grower = null;
    protected SoundType wood_sound = SoundType.f_56736_;
    protected SoundType leaves_sound = SoundType.f_56740_;
    protected float block_hardness = 2.0f;
    protected float explosion_resistance = 5.0f;
    protected boolean has_boat = false;
    protected boolean is_flammable = true;

    private WoodBlockBuilder(String name, String modid, Supplier<CreativeModeTab> tab, DeferredRegister<Item> items, DeferredRegister<Block> blocks) {
        this.items = items;
        this.blocks = blocks;
        this.name = name;
        this.modid = modid;
        this.tab = tab;
        this.decorations_tab = tab;
    }

    public static WoodBlockBuilder of(String name, String modid, Supplier<CreativeModeTab> tab, DeferredRegister<Item> items, DeferredRegister<Block> blocks) {
        return new WoodBlockBuilder(name, modid, tab, items, blocks);
    }

    public WoodBlockBuilder decorationsTab(Supplier<CreativeModeTab> tab) {
        this.decorations_tab = tab;
        return this;
    }

    public WoodBlockBuilder plankColour(MapColor colour) {
        this.plank_colour = colour;
        return this;
    }

    public WoodBlockBuilder barkColour(MapColor colour) {
        this.bark_colour = colour;
        return this;
    }

    public WoodBlockBuilder leavesColour(MapColor colour) {
        this.leaves_colour = colour;
        return this;
    }

    public WoodBlockBuilder treeGrower(AbstractTreeGrower tree) {
        this.tree_grower = tree;
        return this;
    }

    public WoodBlockBuilder woodSound(SoundType sound) {
        this.wood_sound = sound;
        return this;
    }

    public WoodBlockBuilder leavesSound(SoundType sound) {
        this.leaves_sound = sound;
        return this;
    }

    public WoodBlockBuilder blockHardness(float hardness) {
        this.block_hardness = hardness;
        return this;
    }

    public WoodBlockBuilder explosionResistance(float resistance) {
        this.explosion_resistance = resistance;
        return this;
    }

    public WoodBlockBuilder enableBoat() {
        this.has_boat = true;
        return this;
    }

    public WoodBlockBuilder isFireproof() {
        this.is_flammable = false;
        return this;
    }

    public WoodBlock build() {
        return new WoodBlock(this, this.items, this.blocks);
    }

    public BlockBehaviour.Properties constructBaseProperties() {
        return this.constructPropertiesFrom(BlockBehaviour.Properties.m_284310_().m_284180_(this.plank_colour));
    }

    public BlockBehaviour.Properties constructLogProperties() {
        return this.constructPropertiesFrom(BlockBehaviour.Properties.m_284310_().m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? this.plank_colour : this.bark_colour));
    }

    public BlockBehaviour.Properties constructPropertiesFrom(BlockBehaviour.Properties base) {
        if (this.is_flammable) {
            base = base.m_278183_();
        }
        return base.m_60918_(this.wood_sound).m_60913_(this.block_hardness, this.explosion_resistance).m_60999_();
    }
}

