/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.gui;

import immersive_aircraft.client.gui.VehicleScreen;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class SlotRenderer {
    private static final Map<String, Renderer> RENDERERS = new HashMap<String, Renderer>();

    public static void register(String type, Renderer renderer) {
        RENDERERS.put(type, renderer);
    }

    public static Renderer get(String type) {
        return RENDERERS.getOrDefault(type, RENDERERS.get("default"));
    }

    static {
        SlotRenderer.register("inventory", (screen, context, slot, mouseX, mouseY, delta) -> screen.drawImage(context, screen.getX() + slot.x() - 1, screen.getY() + slot.y() - 1, 284, 0, 18, 18));
        SlotRenderer.register("default", (screen, context, slot, mouseX, mouseY, delta) -> screen.drawImage(context, screen.getX() + slot.x() - 3, screen.getY() + slot.y() - 3, 262, 0, 22, 22));
        SlotRenderer.register("boiler", (screen, context, slot, mouseX, mouseY, delta) -> {
            EngineVehicle engineAircraft;
            screen.drawImage(context, screen.getX() + slot.x() - 4, screen.getY() + slot.y() - 18, 318, 0, 24, 39);
            InventoryVehicleEntity patt1160$temp = ((VehicleScreenHandler)screen.m_6262_()).getVehicle();
            if (patt1160$temp instanceof EngineVehicle && (double)(engineAircraft = (EngineVehicle)patt1160$temp).getFuelUtilization() > 0.0) {
                screen.drawImage(context, screen.getX() + slot.x() - 4, screen.getY() + slot.y() - 18, 348, 0, 24, 39);
            }
        });
        SlotRenderer.register("weapon", new BasicRenderer(262, 22));
        SlotRenderer.register("upgrade", new BasicRenderer(262, 44));
        SlotRenderer.register("banner", new BasicRenderer(262, 66));
        SlotRenderer.register("dye", new BasicRenderer(262, 88));
        SlotRenderer.register("booster", new BasicRenderer(262, 110));
    }

    public static interface Renderer {
        public void render(VehicleScreen var1, @NotNull GuiGraphics var2, SlotDescription var3, int var4, int var5, float var6);
    }

    public static class BasicRenderer
    implements Renderer {
        final int u;
        final int v;

        public BasicRenderer(int u, int v) {
            this.u = u;
            this.v = v;
        }

        @Override
        public void render(VehicleScreen screen, @NotNull GuiGraphics context, SlotDescription slot, int mouseX, int mouseY, float delta) {
            if (((VehicleScreenHandler)screen.m_6262_()).getVehicle().getInventory().m_8020_(slot.index()).m_41619_()) {
                screen.drawImage(context, screen.getX() + slot.x() - 3, screen.getY() + slot.y() - 3, this.u, this.v, 22, 22);
            } else {
                screen.drawImage(context, screen.getX() + slot.x() - 3, screen.getY() + slot.y() - 3, 262, 0, 22, 22);
            }
        }
    }
}

