/*
 * Decompiled with CFR 0.152.
 */
package me.muksc.tacztweaks;

import me.muksc.tacztweaks.BlockBreakingManager;
import me.muksc.tacztweaks.Config;
import me.muksc.tacztweaks.client.input.ReduceSensitivityKey;
import me.muksc.tacztweaks.client.input.TiltGunKey;
import me.muksc.tacztweaks.client.input.UnloadKey;
import me.muksc.tacztweaks.compat.lrtactical.LRTacticalCompat;
import me.muksc.tacztweaks.compat.pillagers_gun.PillagersGunCompat;
import me.muksc.tacztweaks.compat.soundphysics.SoundPhysicsCompat;
import me.muksc.tacztweaks.data.BulletInteractionManager;
import me.muksc.tacztweaks.data.BulletParticlesManager;
import me.muksc.tacztweaks.data.BulletSoundsManager;
import me.muksc.tacztweaks.data.MeleeInteractionManager;
import me.muksc.tacztweaks.network.NetworkHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod(value="tacztweaks")
public class TaCZTweaks {
    public static final String MOD_ID = "tacztweaks";
    public final ModContainer container = ModLoadingContext.get().getActiveContainer();

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static MutableComponent translatable(String key, Object ... args) {
        return Component.m_237110_((String)"%s.%s".formatted(MOD_ID, key), (Object[])args);
    }

    public TaCZTweaks() {
        Config.INSTANCE.touch();
        NetworkHandler.INSTANCE.register();
        LRTacticalCompat.INSTANCE.initialize();
        PillagersGunCompat.INSTANCE.initialize();
        SoundPhysicsCompat.INSTANCE.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerReloadListeners(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)BulletInteractionManager.INSTANCE);
        e.addListener((PreparableReloadListener)BulletParticlesManager.INSTANCE);
        e.addListener((PreparableReloadListener)BulletSoundsManager.INSTANCE);
        e.addListener((PreparableReloadListener)MeleeInteractionManager.INSTANCE);
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = e.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockBreakingManager.INSTANCE.onLevelTick(level2);
        BulletParticlesManager.INSTANCE.onLevelTick(level2);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockBreakingManager.INSTANCE.onBlockBreak(level, e.getPos());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        MutableComponent text;
        if (BulletInteractionManager.INSTANCE.hasError()) {
            text = ComponentUtils.m_130748_((Component)Component.m_237113_((String)this.container.getModInfo().getDisplayName())).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)TaCZTweaks.translatable("bullet_interactions.error", new Object[0]).m_130940_(ChatFormatting.RED));
            e.getEntity().m_213846_((Component)text);
        }
        if (BulletParticlesManager.INSTANCE.hasError()) {
            text = ComponentUtils.m_130748_((Component)Component.m_237113_((String)this.container.getModInfo().getDisplayName())).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)TaCZTweaks.translatable("bullet_particles.error", new Object[0]).m_130940_(ChatFormatting.RED));
            e.getEntity().m_213846_((Component)text);
        }
        if (BulletSoundsManager.INSTANCE.hasError()) {
            text = ComponentUtils.m_130748_((Component)Component.m_237113_((String)this.container.getModInfo().getDisplayName())).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)TaCZTweaks.translatable("bullet_sounds.error", new Object[0]).m_130940_(ChatFormatting.RED));
            e.getEntity().m_213846_((Component)text);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="tacztweaks", value={Dist.CLIENT})
    static class ClientModEvents {
        ClientModEvents() {
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, screen) -> Config.INSTANCE.generateConfigScreen((Screen)screen)));
        }

        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(ReduceSensitivityKey.KEY);
            event.register(TiltGunKey.KEY);
            event.register(UnloadKey.KEY);
        }
    }
}

