/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.rocks.world.level.block;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import tv.mapper.embellishcraft.core.util.RockType;
import tv.mapper.mapperbase.world.level.block.CustomBlock;
import tv.mapper.mapperbase.world.level.block.CustomButtonBlock;
import tv.mapper.mapperbase.world.level.block.CustomPressurePlateBlock;
import tv.mapper.mapperbase.world.level.block.CustomSlabBlock;
import tv.mapper.mapperbase.world.level.block.CustomStairsBlock;
import tv.mapper.mapperbase.world.level.block.CustomWallBlock;
import tv.mapper.mapperbase.world.level.block.ToolTypes;

public class InitRockBlocks {
    public static final DeferredRegister<Block> ROCK_BLOCK_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"embellishcraft");
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_BLOCKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName(), () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_().m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_BLOCKS.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> ROCK_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomButtonBlock>> ROCK_BUTTONS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_button", () -> new CustomButtonBlock(false, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.NONE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_COBBLESTONES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_COBBLESTONE_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_COBBLESTONES.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_COBBLESTONE_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> ROCK_COBBLESTONE_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_COBBLESTONE_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_COBBLESTONE_BRICKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_COBBLESTONE_BRICKS_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_COBBLESTONES.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_COBBLESTONE_BRICKS_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> ROCK_COBBLESTONE_BRICKS_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_COBBLESTONE_BRICKS_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> SMOOTH_ROCK_BLOCKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName(), () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> SMOOTH_ROCK_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName() + "_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)SMOOTH_ROCK_BLOCKS.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> SMOOTH_ROCK_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName() + "_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> SMOOTH_ROCK_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName() + "_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> SMOOTH_ROCK_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName() + "_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> POLISHED_ROCK_BLOCKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName(), () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> POLISHED_ROCK_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName() + "_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)POLISHED_ROCK_BLOCKS.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> POLISHED_ROCK_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName() + "_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> POLISHED_ROCK_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName() + "_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> POLISHED_ROCK_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName() + "_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_PAVINGS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_PAVING_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_PAVINGS.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_PAVING_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> ROCK_PAVING_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_PAVING_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_TILES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_TILES_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_TILES.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_TILES_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> ROCK_TILES_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_TILES_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_BRICKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_BRICKS_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_BRICKS.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_BRICKS_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> ROCK_BRICKS_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_BRICKS_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_LARGE_BRICKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_LARGE_BRICKS_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_LARGE_BRICKS.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_LARGE_BRICKS_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> ROCK_LARGE_BRICKS_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_LARGE_BRICKS_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_PAVING_STONES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_PAVING_STONES_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_PAVING_STONES.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_PAVING_STONES_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomWallBlock>> ROCK_PAVING_STONES_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_PAVING_STONES_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_ORNAMENTS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_ornament", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomPressurePlateBlock>> ROCK_ORNAMENT_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_ornament_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomBlock>> ROCK_ROOFTILES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomStairsBlock>> ROCK_ROOFTILES_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_rooftiles_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)ROCK_BLOCKS.get(type).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, RegistryObject<CustomSlabBlock>> ROCK_ROOFTILES_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(type.getColor()).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final RegistryObject<CustomBlock> PAVING_STONES = ROCK_BLOCK_REGISTRY.register("paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("paving_stones_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50069_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f).m_60999_(), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60910_().m_60913_(1.5f, 6.0f).m_60999_(), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SMOOTH_ANDESITE = ROCK_BLOCK_REGISTRY.register("smooth_andesite", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SMOOTH_ANDESITE_STAIRS = ROCK_BLOCK_REGISTRY.register("smooth_andesite_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)SMOOTH_ANDESITE.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SMOOTH_ANDESITE_SLAB = ROCK_BLOCK_REGISTRY.register("smooth_andesite_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> SMOOTH_ANDESITE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_andesite_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SMOOTH_ANDESITE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_andesite_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomButtonBlock> ANDESITE_BUTTON = ROCK_BLOCK_REGISTRY.register("andesite_button", () -> new CustomButtonBlock(false, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.NONE));
    public static final RegistryObject<CustomBlock> ANDESITE_PAVING = ROCK_BLOCK_REGISTRY.register("andesite_paving", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> ANDESITE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_paving_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50334_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> ANDESITE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> ANDESITE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("andesite_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> ANDESITE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_paving_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> ANDESITE_TILES = ROCK_BLOCK_REGISTRY.register("andesite_tiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> ANDESITE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_tiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50334_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> ANDESITE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> ANDESITE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("andesite_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> ANDESITE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_tiles_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> ANDESITE_BRICKS = ROCK_BLOCK_REGISTRY.register("andesite_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> ANDESITE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50334_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> ANDESITE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> ANDESITE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("andesite_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> ANDESITE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> ANDESITE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> ANDESITE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50334_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> ANDESITE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> ANDESITE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> ANDESITE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> ANDESITE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> ANDESITE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50334_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> ANDESITE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> ANDESITE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> ANDESITE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> ANDESITE_ORNAMENT = ROCK_BLOCK_REGISTRY.register("andesite_ornament", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> ANDESITE_ORNAMENT_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_ornament_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> ANDESITE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("andesite_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> ANDESITE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_rooftiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50334_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> ANDESITE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SMOOTH_DIORITE = ROCK_BLOCK_REGISTRY.register("smooth_diorite", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SMOOTH_DIORITE_STAIRS = ROCK_BLOCK_REGISTRY.register("smooth_diorite_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)SMOOTH_DIORITE.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SMOOTH_DIORITE_SLAB = ROCK_BLOCK_REGISTRY.register("smooth_diorite_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> SMOOTH_DIORITE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_diorite_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SMOOTH_DIORITE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_diorite_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomButtonBlock> DIORITE_BUTTON = ROCK_BLOCK_REGISTRY.register("diorite_button", () -> new CustomButtonBlock(false, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.NONE));
    public static final RegistryObject<CustomBlock> DIORITE_PAVING = ROCK_BLOCK_REGISTRY.register("diorite_paving", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> DIORITE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_paving_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50228_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> DIORITE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> DIORITE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("diorite_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> DIORITE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_paving_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> DIORITE_TILES = ROCK_BLOCK_REGISTRY.register("diorite_tiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> DIORITE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_tiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50228_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> DIORITE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> DIORITE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("diorite_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> DIORITE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_tiles_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> DIORITE_BRICKS = ROCK_BLOCK_REGISTRY.register("diorite_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> DIORITE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50228_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> DIORITE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> DIORITE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("diorite_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> DIORITE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> DIORITE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> DIORITE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50228_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> DIORITE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> DIORITE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> DIORITE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> DIORITE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> DIORITE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50228_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> DIORITE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> DIORITE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> DIORITE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> DIORITE_ORNAMENT = ROCK_BLOCK_REGISTRY.register("diorite_ornament", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> DIORITE_ORNAMENT_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_ornament_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283942_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> DIORITE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("diorite_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> DIORITE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_rooftiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50228_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> DIORITE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SMOOTH_GRANITE = ROCK_BLOCK_REGISTRY.register("smooth_granite", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SMOOTH_GRANITE_STAIRS = ROCK_BLOCK_REGISTRY.register("smooth_granite_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)SMOOTH_GRANITE.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SMOOTH_GRANITE_SLAB = ROCK_BLOCK_REGISTRY.register("smooth_granite_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> SMOOTH_GRANITE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_granite_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SMOOTH_GRANITE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_granite_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomButtonBlock> GRANITE_BUTTON = ROCK_BLOCK_REGISTRY.register("granite_button", () -> new CustomButtonBlock(false, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.NONE));
    public static final RegistryObject<CustomBlock> GRANITE_PAVING = ROCK_BLOCK_REGISTRY.register("granite_paving", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> GRANITE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_paving_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50122_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> GRANITE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("granite_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> GRANITE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("granite_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> GRANITE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_paving_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> GRANITE_TILES = ROCK_BLOCK_REGISTRY.register("granite_tiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> GRANITE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_tiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50122_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> GRANITE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("granite_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> GRANITE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("granite_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> GRANITE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_tiles_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> GRANITE_BRICKS = ROCK_BLOCK_REGISTRY.register("granite_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> GRANITE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50122_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> GRANITE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("granite_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> GRANITE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("granite_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> GRANITE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> GRANITE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("granite_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> GRANITE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_large_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50122_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> GRANITE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("granite_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> GRANITE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("granite_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> GRANITE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> GRANITE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("granite_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> GRANITE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_paving_stones_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50122_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> GRANITE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("granite_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> GRANITE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("granite_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> GRANITE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> GRANITE_ORNAMENT = ROCK_BLOCK_REGISTRY.register("granite_ornament", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> GRANITE_ORNAMENT_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_ornament_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283762_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> GRANITE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("granite_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> GRANITE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_rooftiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50122_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> GRANITE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("granite_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomButtonBlock> SANDSTONE_BUTTON = ROCK_BLOCK_REGISTRY.register("sandstone_button", () -> new CustomButtonBlock(false, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.NONE));
    public static final RegistryObject<CustomWallBlock> SMOOTH_SANDSTONE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_sandstone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SMOOTH_SANDSTONE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_sandstone_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> POLISHED_SANDSTONE = ROCK_BLOCK_REGISTRY.register("polished_sandstone", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> POLISHED_SANDSTONE_STAIRS = ROCK_BLOCK_REGISTRY.register("polished_sandstone_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50062_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> POLISHED_SANDSTONE_SLAB = ROCK_BLOCK_REGISTRY.register("polished_sandstone_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> POLISHED_SANDSTONE_WALL = ROCK_BLOCK_REGISTRY.register("polished_sandstone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> POLISHED_SANDSTONE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("polished_sandstone_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SANDSTONE_PAVING = ROCK_BLOCK_REGISTRY.register("sandstone_paving", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SANDSTONE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50062_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SANDSTONE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> SANDSTONE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SANDSTONE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_paving_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SANDSTONE_TILES = ROCK_BLOCK_REGISTRY.register("sandstone_tiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SANDSTONE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_tiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50062_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SANDSTONE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> SANDSTONE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SANDSTONE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_tiles_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SANDSTONE_BRICKS = ROCK_BLOCK_REGISTRY.register("sandstone_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SANDSTONE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50062_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SANDSTONE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> SANDSTONE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SANDSTONE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SANDSTONE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SANDSTONE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50062_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SANDSTONE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> SANDSTONE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SANDSTONE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SANDSTONE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SANDSTONE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50062_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SANDSTONE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> SANDSTONE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SANDSTONE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283761_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> SANDSTONE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("sandstone_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> SANDSTONE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_rooftiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50062_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> SANDSTONE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomButtonBlock> RED_SANDSTONE_BUTTON = ROCK_BLOCK_REGISTRY.register("red_sandstone_button", () -> new CustomButtonBlock(false, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.NONE));
    public static final RegistryObject<CustomWallBlock> SMOOTH_RED_SANDSTONE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_red_sandstone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> SMOOTH_RED_SANDSTONE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_red_sandstone_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> POLISHED_RED_SANDSTONE = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> POLISHED_RED_SANDSTONE_STAIRS = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50394_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> POLISHED_RED_SANDSTONE_SLAB = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> POLISHED_RED_SANDSTONE_WALL = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> POLISHED_RED_SANDSTONE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> RED_SANDSTONE_PAVING = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> RED_SANDSTONE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50394_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> RED_SANDSTONE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> RED_SANDSTONE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> RED_SANDSTONE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> RED_SANDSTONE_TILES = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> RED_SANDSTONE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50394_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> RED_SANDSTONE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> RED_SANDSTONE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> RED_SANDSTONE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> RED_SANDSTONE_BRICKS = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> RED_SANDSTONE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50394_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> RED_SANDSTONE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> RED_SANDSTONE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> RED_SANDSTONE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> RED_SANDSTONE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> RED_SANDSTONE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50394_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> RED_SANDSTONE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> RED_SANDSTONE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> RED_SANDSTONE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> RED_SANDSTONE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> RED_SANDSTONE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50394_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> RED_SANDSTONE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> RED_SANDSTONE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> RED_SANDSTONE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> RED_SANDSTONE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("red_sandstone_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> RED_SANDSTONE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_rooftiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50394_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> RED_SANDSTONE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> TERRACOTTA_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50352_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> TERRACOTTA_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> TERRACOTTA_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> TERRACOTTA_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomButtonBlock> TERRACOTTA_BUTTON = ROCK_BLOCK_REGISTRY.register("terracotta_button", () -> new CustomButtonBlock(false, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.NONE));
    public static final RegistryObject<CustomBlock> POLISHED_TERRACOTTA = ROCK_BLOCK_REGISTRY.register("polished_terracotta", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> POLISHED_TERRACOTTA_STAIRS = ROCK_BLOCK_REGISTRY.register("polished_terracotta_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)POLISHED_TERRACOTTA.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> POLISHED_TERRACOTTA_SLAB = ROCK_BLOCK_REGISTRY.register("polished_terracotta_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> POLISHED_TERRACOTTA_WALL = ROCK_BLOCK_REGISTRY.register("polished_terracotta_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> POLISHED_TERRACOTTA_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("polished_terracotta_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> TERRACOTTA_PAVING = ROCK_BLOCK_REGISTRY.register("terracotta_paving", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> TERRACOTTA_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)TERRACOTTA_PAVING.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> TERRACOTTA_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> TERRACOTTA_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> TERRACOTTA_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_paving_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> TERRACOTTA_TILES = ROCK_BLOCK_REGISTRY.register("terracotta_tiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> TERRACOTTA_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_tiles_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)TERRACOTTA_TILES.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> TERRACOTTA_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> TERRACOTTA_TILES_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> TERRACOTTA_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_tiles_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> TERRACOTTA_BRICKS = ROCK_BLOCK_REGISTRY.register("terracotta_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> TERRACOTTA_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_bricks_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)TERRACOTTA_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> TERRACOTTA_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> TERRACOTTA_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> TERRACOTTA_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> TERRACOTTA_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> TERRACOTTA_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)TERRACOTTA_LARGE_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> TERRACOTTA_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> TERRACOTTA_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> TERRACOTTA_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> TERRACOTTA_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> TERRACOTTA_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones_stairs", () -> new CustomStairsBlock(() -> ((CustomBlock)TERRACOTTA_PAVING_STONES.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> TERRACOTTA_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> TERRACOTTA_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomPressurePlateBlock> TERRACOTTA_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283750_).m_60910_().m_60913_(1.5f, 6.0f), BlockSetType.f_271479_, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomBlock> TERRACOTTA_ROOFTILES = ROCK_BLOCK_REGISTRY.register("terracotta_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomStairsBlock> TERRACOTTA_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_rooftiles_stairs", () -> new CustomStairsBlock(() -> Blocks.f_50352_.m_49966_(), BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> TERRACOTTA_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60913_(1.5f, 6.0f), ToolTypes.PICKAXE));

    public static void init() {
        ROCK_BLOCK_REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

