/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.world.level.block.entity;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import tv.mapper.embellishcraft.core.world.block.entity.ModTileEntityTypes;
import tv.mapper.embellishcraft.furniture.world.inventory.CrateContainer;
import tv.mapper.embellishcraft.furniture.world.level.block.CrateBlock;

public class CrateTileEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS = IntStream.range(0, 16).toArray();
    private NonNullList<ItemStack> crateContents = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    private LazyOptional<IItemHandlerModifiable> crateHandler = LazyOptional.of(this::createHandler);

    public CrateTileEntity(BlockEntityType<?> typeIn, BlockPos p_155630_, BlockState p_155631_) {
        super(typeIn, p_155630_, p_155631_);
    }

    public CrateTileEntity(BlockPos p_155630_, BlockState p_155631_) {
        this(ModTileEntityTypes.CRATE, p_155630_, p_155631_);
    }

    public int m_6643_() {
        return 16;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.crateContents) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"embellishcraft.container.wooden_crate");
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.loadFromTag(pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.m_59634_(pTag)) {
            ContainerHelper.m_18976_((CompoundTag)pTag, this.crateContents, (boolean)false);
        }
    }

    public void loadFromTag(CompoundTag pTag) {
        this.crateContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(pTag) && pTag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)pTag, this.crateContents);
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.crateContents;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.crateContents = itemsIn;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return CrateContainer.createCrate4X4(id, player, (Container)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.crateHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((Container)this){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (Block.m_49814_((Item)stack.m_41720_()) instanceof CrateBlock || Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.crateHandler != null) {
            this.crateHandler.invalidate();
        }
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return !(Block.m_49814_((Item)itemStackIn.m_41720_()) instanceof CrateBlock) && !(Block.m_49814_((Item)itemStackIn.m_41720_()) instanceof ShulkerBoxBlock);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }
}

