/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.world.level.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tv.mapper.embellishcraft.furniture.world.level.block.entity.CrateTileEntity;
import tv.mapper.mapperbase.world.level.block.ToolManager;
import tv.mapper.mapperbase.world.level.block.ToolTiers;
import tv.mapper.mapperbase.world.level.block.ToolTypes;

public class CrateBlock
extends BaseEntityBlock
implements ToolManager {
    protected ToolTiers tier;
    protected ToolTypes tool;
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");

    public CrateBlock(BlockBehaviour.Properties properties, ToolTypes tool) {
        super(properties);
        this.tool = tool;
        this.tier = ToolTiers.WOOD;
    }

    public CrateBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier) {
        super(properties);
        this.tool = tool;
        this.tier = tier;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!world.f_46443_) {
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof CrateTileEntity) {
                MenuProvider inamedcontainerprovider = this.m_7246_(state, world, pos);
                if (inamedcontainerprovider != null) {
                    player.m_5893_(inamedcontainerprovider);
                    world.m_5594_(null, pos, SoundEvents.f_12627_, SoundSource.BLOCKS, 1.0f, (float)(0.75 + Math.random() * 0.5));
                }
            } else {
                throw new IllegalStateException("Attempted to open a crate while it was not one!");
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CrateTileEntity) {
            CrateTileEntity crateBlockEntity = (CrateTileEntity)blockEntity;
            if (!pLevel.f_46443_ && pPlayer.m_7500_() && !crateBlockEntity.m_7983_()) {
                ItemStack itemstack = new ItemStack((ItemLike)this.m_7374_());
                blockEntity.m_187476_(itemstack);
                if (crateBlockEntity.m_8077_()) {
                    itemstack.m_41714_(crateBlockEntity.m_7770_());
                }
                ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                pLevel.m_7967_((Entity)itementity);
            } else {
                crateBlockEntity.m_59640_(pPlayer);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        CompoundTag compoundnbt = stack.m_41737_("BlockEntityTag");
        if (compoundnbt != null) {
            if (compoundnbt.m_128425_("LootTable", 8)) {
                tooltip.add((Component)Component.m_237113_((String)"???????"));
            }
            if (compoundnbt.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent itextcomponent = itemstack.m_41786_().m_6881_();
                    itextcomponent.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                    tooltip.add((Component)itextcomponent);
                }
                if (j - i > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof CrateTileEntity) {
                worldIn.m_46717_(pos, state.m_60734_());
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new CrateTileEntity(p_153215_, p_153216_);
    }

    public ToolTiers getTier() {
        return this.tier;
    }

    public ToolTypes getTool() {
        return this.tool;
    }
}

