/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.world.level.block;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.embellishcraft.furniture.world.entity.SitEntity;
import tv.mapper.embellishcraft.furniture.world.level.block.SitBlock;
import tv.mapper.mapperbase.world.level.block.CustomBlock;
import tv.mapper.mapperbase.world.level.block.ToolTiers;
import tv.mapper.mapperbase.world.level.block.ToolTypes;

public class CouchBlock
extends CustomBlock
implements SimpleWaterloggedBlock,
SitBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty LEFT_END = BooleanProperty.m_61465_((String)"left_end");
    public static final BooleanProperty RIGHT_END = BooleanProperty.m_61465_((String)"right_end");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SLAB_BOTTOM = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = CouchBlock.makeShapes(SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> CouchBlock.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    public CouchBlock(BlockBehaviour.Properties properties, ToolTypes tool) {
        super(properties, tool);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)LEFT_END, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_END, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public CouchBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier) {
        super(properties, tool, tier);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)LEFT_END, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_END, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SLAB_BOTTOM_SHAPES[SHAPE_BY_STATE[this.getCouchShape(state)]];
    }

    private int getCouchShape(BlockState state) {
        return ((StairsShape)state.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return !level.m_46859_(pos.m_7495_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        FluidState ifluidstate = context.m_43725_().m_6425_(blockpos);
        boolean leftend = true;
        boolean rightend = true;
        Direction facing = context.m_8125_();
        StairsShape shape = CouchBlock.getShapeProperty((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing), (BlockGetter)context.m_43725_(), blockpos);
        if (shape == StairsShape.STRAIGHT) {
            BlockState leftstate;
            BlockState rightstate = switch (facing) {
                case Direction.NORTH -> {
                    leftstate = iblockreader.m_8055_(blockpos.m_122024_());
                    yield iblockreader.m_8055_(blockpos.m_122029_());
                }
                case Direction.SOUTH -> {
                    leftstate = iblockreader.m_8055_(blockpos.m_122029_());
                    yield iblockreader.m_8055_(blockpos.m_122024_());
                }
                case Direction.EAST -> {
                    leftstate = iblockreader.m_8055_(blockpos.m_122012_());
                    yield iblockreader.m_8055_(blockpos.m_122019_());
                }
                case Direction.WEST -> {
                    leftstate = iblockreader.m_8055_(blockpos.m_122019_());
                    yield iblockreader.m_8055_(blockpos.m_122012_());
                }
                default -> {
                    leftstate = iblockreader.m_8055_(blockpos.m_122024_());
                    yield iblockreader.m_8055_(blockpos.m_122029_());
                }
            };
            if (leftstate.m_60734_() instanceof CouchBlock) {
                leftend = false;
            }
            if (rightstate.m_60734_() instanceof CouchBlock) {
                rightend = false;
            }
        } else {
            leftend = false;
            rightend = false;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)shape)).m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)LEFT_END, (Comparable)Boolean.valueOf(leftend))).m_61124_((Property)RIGHT_END, (Comparable)Boolean.valueOf(rightend))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState blockstate = worldIn.m_8055_(pos.m_121945_(direction));
        if (CouchBlock.isCouchBlock(blockstate) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && CouchBlock.isDifferentCouch(state, worldIn, pos, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (CouchBlock.isCouchBlock(blockstate1) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && CouchBlock.isDifferentCouch(state, worldIn, pos, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean rightend;
        boolean leftend;
        StairsShape shape = (StairsShape)stateIn.m_61143_(SHAPE);
        Direction direction = (Direction)stateIn.m_61143_((Property)FACING);
        if (facing.m_122434_().m_122479_()) {
            shape = CouchBlock.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos);
        }
        if (shape == StairsShape.STRAIGHT) {
            BlockState leftstate;
            BlockState rightstate = switch (direction) {
                case Direction.NORTH -> {
                    leftstate = worldIn.m_8055_(currentPos.m_122024_());
                    yield worldIn.m_8055_(currentPos.m_122029_());
                }
                case Direction.SOUTH -> {
                    leftstate = worldIn.m_8055_(currentPos.m_122029_());
                    yield worldIn.m_8055_(currentPos.m_122024_());
                }
                case Direction.EAST -> {
                    leftstate = worldIn.m_8055_(currentPos.m_122012_());
                    yield worldIn.m_8055_(currentPos.m_122019_());
                }
                case Direction.WEST -> {
                    leftstate = worldIn.m_8055_(currentPos.m_122019_());
                    yield worldIn.m_8055_(currentPos.m_122012_());
                }
                default -> {
                    leftstate = worldIn.m_8055_(currentPos.m_122024_());
                    yield worldIn.m_8055_(currentPos.m_122029_());
                }
            };
            leftend = !(leftstate.m_60734_() instanceof CouchBlock);
            rightend = !(rightstate.m_60734_() instanceof CouchBlock);
        } else {
            leftend = false;
            rightend = false;
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return facing.m_122434_().m_122479_() ? (BlockState)((BlockState)((BlockState)stateIn.m_61124_(SHAPE, (Comparable)shape)).m_61124_((Property)LEFT_END, (Comparable)Boolean.valueOf(leftend))).m_61124_((Property)RIGHT_END, (Comparable)Boolean.valueOf(rightend)) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static boolean isDifferentCouch(BlockState state, BlockGetter worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.m_8055_(pos.m_121945_(face));
        return !CouchBlock.isCouchBlock(blockstate) || blockstate.m_61143_((Property)FACING) != state.m_61143_((Property)FACING);
    }

    public static boolean isCouchBlock(BlockState state) {
        return state.m_60734_() instanceof CouchBlock;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, LEFT_END, RIGHT_END, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return SitEntity.create(level, pos, 0.55, 0.3, player, (Direction)state.m_61143_((Property)FACING), false);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }
}

