/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.data.gen;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import tv.mapper.embellishcraft.core.data.gen.ECBlockStates;
import tv.mapper.embellishcraft.core.util.McWoods;
import tv.mapper.embellishcraft.furniture.world.level.block.CouchBlock;
import tv.mapper.embellishcraft.furniture.world.level.block.InitFurnitureBlocks;
import tv.mapper.embellishcraft.furniture.world.level.block.PlateBlock;
import tv.mapper.embellishcraft.furniture.world.level.block.TableBlock;

public class FurnitureBlockStates
extends ECBlockStates {
    public FurnitureBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    @Override
    protected void registerStatesAndModels() {
        int j;
        for (j = 0; j < McWoods.values().length; ++j) {
            this.horizontalBlock((Block)InitFurnitureBlocks.CHAIR_BLOCKS.get((Object)McWoods.byId(j)).get(), (ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + McWoods.byId(j).m_7912_() + "_chair"), 0);
            this.horizontalBlock((Block)InitFurnitureBlocks.TERRACE_CHAIR_BLOCKS.get((Object)McWoods.byId(j)).get(), (ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + McWoods.byId(j).m_7912_() + "_terrace_chair"), 0);
            this.tableBlock((Block)InitFurnitureBlocks.TABLE_BLOCKS.get((Object)McWoods.byId(j)).get());
            this.tableBlock((Block)InitFurnitureBlocks.FANCY_TABLE_BLOCKS.get((Object)McWoods.byId(j)).get());
            this.simpleBlock((Block)InitFurnitureBlocks.TERRACE_TABLE_BLOCKS.get((Object)McWoods.byId(j)).get());
            this.simpleBlock((Block)InitFurnitureBlocks.WOODEN_CRATE_BLOCKS.get((Object)McWoods.byId(j)).get());
        }
        this.simpleBlock((Block)InitFurnitureBlocks.STEEL_TERRACE_TABLE.get());
        this.horizontalBlock((Block)InitFurnitureBlocks.STEEL_TERRACE_CHAIR.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/steel_terrace_chair"), 0);
        for (j = 0; j < DyeColor.values().length; ++j) {
            this.couchBlock((CouchBlock)InitFurnitureBlocks.COUCH_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 90);
            this.horizontalBlock((Block)InitFurnitureBlocks.PILLOW_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), (ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + DyeColor.m_41053_((int)j).m_7912_() + "_pillow"), 0);
            this.bedBlock((BedBlock)InitFurnitureBlocks.OAK_FANCY_BED_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 180);
            this.bedBlock((BedBlock)InitFurnitureBlocks.BIRCH_FANCY_BED_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 180);
            this.bedBlock((BedBlock)InitFurnitureBlocks.SPRUCE_FANCY_BED_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 180);
            this.bedBlock((BedBlock)InitFurnitureBlocks.JUNGLE_FANCY_BED_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 180);
            this.bedBlock((BedBlock)InitFurnitureBlocks.DARK_OAK_FANCY_BED_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 180);
            this.bedBlock((BedBlock)InitFurnitureBlocks.ACACIA_FANCY_BED_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 180);
            this.bedBlock((BedBlock)InitFurnitureBlocks.WARPED_FANCY_BED_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 180);
            this.bedBlock((BedBlock)InitFurnitureBlocks.CRIMSON_FANCY_BED_BLOCKS.get(DyeColor.m_41053_((int)j)).get(), 180);
        }
        this.plateBlock((Block)InitFurnitureBlocks.PLATE.get());
    }

    private void plateBlock(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 1; i < 9; ++i) {
            builder.partialState().with((Property)PlateBlock.PLATES, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/plate_" + i)).addModel();
        }
    }

    private void tableBlock(Block block) {
        String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + name + "_top")).addModel()).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + name + "_foot")).uvLock(true).addModel()).condition((Property)TableBlock.TABLE_NORTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + name + "_foot")).rotationY(90).uvLock(true).addModel()).condition((Property)TableBlock.TABLE_EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + name + "_foot")).rotationY(180).uvLock(true).addModel()).condition((Property)TableBlock.TABLE_SOUTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + name + "_foot")).rotationY(270).uvLock(true).addModel()).condition((Property)TableBlock.TABLE_WEST, (Comparable[])new Boolean[]{true}).end();
    }

    private void couchBlock(CouchBlock block) {
        this.couchBlock(block, 0);
    }

    private void couchBlock(CouchBlock block, int offset) {
        String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + name + "_left")).rotationY((int)(dir.m_122435_() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition((Property)CouchBlock.LEFT_END, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + name + "_right")).rotationY((int)(dir.m_122435_() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition((Property)CouchBlock.RIGHT_END, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/" + name)).rotationY((int)(dir.m_122435_() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.STRAIGHT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/outer_" + name)).rotationY((int)(dir.m_122435_() + 270.0f + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.OUTER_LEFT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/inner_" + name)).rotationY((int)(dir.m_122435_() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.INNER_LEFT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/outer_" + name)).rotationY((int)(dir.m_122435_() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.OUTER_RIGHT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.mod_id + ":block/inner_" + name)).rotationY((int)(dir.m_122435_() + 90.0f + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.INNER_RIGHT}).end();
        }
    }

    private void bedBlock(BedBlock block, int offset) {
        String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            for (BedPart type : BedPart.values()) {
                String model = type == BedPart.HEAD ? this.mod_id + ":block/" + name + "_head" : this.mod_id + ":block/" + name + "_foot";
                builder.partialState().with((Property)BedBlock.f_49440_, (Comparable)type).with((Property)ChestBlock.f_51478_, (Comparable)dir).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile(model)).rotationY((int)((dir.m_122435_() + (float)offset) % 360.0f)).addModel();
            }
        }
    }

    private void chestBlock(ChestBlock block, int offset) {
        String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            for (ChestType type : ChestType.values()) {
                String model = type == ChestType.SINGLE ? this.mod_id + ":block/" + name : (type == ChestType.LEFT ? this.mod_id + ":block/" + name + "_left" : this.mod_id + ":block/" + name + "_right");
                builder.partialState().with((Property)ChestBlock.f_51479_, (Comparable)type).with((Property)ChestBlock.f_51478_, (Comparable)dir).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile(model)).rotationY((int)((dir.m_122435_() + (float)offset) % 360.0f)).addModel();
            }
        }
    }
}

