/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft;

import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mapper.embellishcraft.building.world.item.InitBuildingItems;
import tv.mapper.embellishcraft.building.world.level.block.InitBuildingBlocks;
import tv.mapper.embellishcraft.core.proxy.ClientProxy;
import tv.mapper.embellishcraft.core.proxy.IProxy;
import tv.mapper.embellishcraft.core.proxy.ServerProxy;
import tv.mapper.embellishcraft.core.world.item.ModItemGroups;
import tv.mapper.embellishcraft.furniture.world.entity.InitFurnitureEntities;
import tv.mapper.embellishcraft.furniture.world.inventory.ModContainers;
import tv.mapper.embellishcraft.furniture.world.item.InitFurnitureItems;
import tv.mapper.embellishcraft.furniture.world.level.block.InitFurnitureBlocks;
import tv.mapper.embellishcraft.industrial.world.item.InitIndustrialItems;
import tv.mapper.embellishcraft.industrial.world.level.block.InitIndustrialBlocks;
import tv.mapper.embellishcraft.lights.world.item.InitLightItems;
import tv.mapper.embellishcraft.lights.world.level.block.InitLightBlocks;
import tv.mapper.embellishcraft.rocks.world.item.InitRockItems;
import tv.mapper.embellishcraft.rocks.world.level.block.InitRockBlocks;

@Mod(value="embellishcraft")
public class EmbellishCraft {
    public static final Logger LOGGER = LogManager.getLogger();
    public static IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public EmbellishCraft() {
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.COMMON, FMLPaths.CONFIGDIR.get());
        InitRockBlocks.init();
        InitIndustrialBlocks.init();
        InitBuildingBlocks.init();
        InitFurnitureBlocks.init();
        InitFurnitureBlocks.postInit();
        InitLightBlocks.init();
        InitRockItems.init();
        InitIndustrialItems.init();
        InitBuildingItems.init();
        InitFurnitureItems.init();
        InitLightItems.init();
        InitFurnitureEntities.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItemGroups.init(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::serverSetup);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("EmbellishCraft: setup started.");
        if (ModList.get().isLoaded("embellishcraft_bop")) {
            LOGGER.info("EmbellishCraft: BoP addon detected.");
        }
        proxy.setup(event);
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void serverSetup(FMLDedicatedServerSetupEvent event) {
    }
}

