/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.util.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ItemTagModifier
extends LootModifier {
    public static final Supplier<Codec<ItemTagModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ItemTagModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)TagKey.m_203877_((ResourceKey)Registries.f_256913_).fieldOf("tag").forGetter(m -> m.tag)).apply((Applicative)inst, ItemTagModifier::new)));
    private final TagKey<Item> tag;

    public ItemTagModifier(LootItemCondition[] conditionsIn, TagKey<Item> itemTag) {
        super(conditionsIn);
        this.tag = itemTag;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        LootTable lootTable = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(this.tag))).m_79167_();
        lootTable.m_79148_(context, arg_0 -> generatedLoot.add(arg_0));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

