/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.graphics;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.Renderer;

public class MultiImage
extends Renderer {
    private List<Image> images = new ArrayList<Image>();
    private int current = 0;

    public MultiImage(List<Image> images) {
        this.images = images;
    }

    public MultiImage(ResourceLocation file, int fileWidth, int fileHeight, List<Rect2i> rects) {
        for (Rect2i rect : rects) {
            this.images.add(new Image(file, fileWidth, fileHeight, rect.m_110085_(), rect.m_110086_(), rect.m_110090_(), rect.m_110091_()));
        }
    }

    public MultiImage(ResourceLocation file, int fileWidth, int fileHeight, int count) {
        this(file, fileWidth, fileHeight, MultiImage.fromFile(fileWidth, fileHeight, count));
    }

    public static List<Rect2i> fromFile(int fileWidth, int fileHeight, int count) {
        ArrayList<Rect2i> rects = new ArrayList<Rect2i>();
        for (int i = 0; i < count; ++i) {
            rects.add(new Rect2i(0, fileHeight / count * i, fileWidth, fileHeight / count));
        }
        return rects;
    }

    public MultiImage setImage(int index) {
        this.current = Math.min(Math.max(index, 0), this.count() - 1);
        return this;
    }

    public int current() {
        return this.current;
    }

    public int count() {
        return this.images.size();
    }

    @Override
    public void render(GuiGraphics graphics, int posX, int posY) {
        if (this.count() > 0) {
            this.images.get(this.current).render(graphics, posX, posY);
        }
    }
}

