/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.AnimatedImage;
import net.tejty.gamediscs.games.graphics.BreakParticleRenderer;
import net.tejty.gamediscs.games.graphics.ParticleColor;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Particle;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.games.util.Sprite;

public class FlappyBirdGame
extends Game {
    private Sprite bird = new Sprite(new Vec2(20.0f, 30.0f), new Vec2(10.0f, 8.0f), new AnimatedImage(new ResourceLocation("gamediscs", "textures/games/sprite/bird.png"), 10, 32, 4, 2));
    private List<Sprite> pipes = new ArrayList<Sprite>();
    private final Sprite ground = new Sprite(new Vec2(0.0f, 84.0f), new Vec2(156.0f, 16.0f), new ResourceLocation("gamediscs", "textures/games/sprite/ground.png"));
    private int pipeSpawnTimer = 0;

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.bird = new Sprite(new Vec2(20.0f, 30.0f), new Vec2(10.0f, 8.0f), new AnimatedImage(new ResourceLocation("gamediscs", "textures/games/sprite/bird.png"), 10, 32, 4, 2));
        this.pipes = new ArrayList<Sprite>();
        this.ground.setVelocity(new Vec2(-2.5f, 0.0f));
        this.bird.show();
    }

    @Override
    public synchronized void start() {
        super.start();
        this.pipeSpawnTimer = 0;
    }

    @Override
    public synchronized void tick() {
        super.tick();
        if (this.stage != GameStage.DIED) {
            this.bird.animTick();
        }
        if (this.stage != GameStage.DIED && this.stage != GameStage.WON) {
            this.ground.tick();
            if (this.ground.getX() <= -16.0f) {
                this.ground.moveBy(new Vec2(16.0f, 0.0f));
            }
        }
    }

    @Override
    public synchronized void gameTick() {
        super.gameTick();
        this.bird.tick();
        this.bird.addVelocity(new Vec2(0.0f, 0.75f));
        this.bird.setVelocity(this.bird.getVelocity().m_165903_(0.9f));
        if (this.pipeSpawnTimer <= 0) {
            this.spawnPipe();
            this.pipeSpawnTimer = 30;
        }
        for (int i = 0; i < this.pipes.size(); ++i) {
            Sprite pipe = this.pipes.get(i);
            boolean flag = pipe.getX() + pipe.getWidth() >= this.bird.getX() && pipe.getY() < 0.0f;
            pipe.tick();
            if (flag && pipe.getX() + pipe.getWidth() < this.bird.getX()) {
                ++this.score;
                this.soundPlayer.playPoint();
            }
            if (pipe.getX() + pipe.getWidth() < 0.0f) {
                this.pipes.remove(pipe);
                --i;
            }
            if (!this.bird.isTouching(pipe)) continue;
            this.die();
        }
        if (this.bird.isTouching(this.ground) || this.bird.getY() < 0.0f) {
            this.die();
        }
        if (this.ticks % 2 == 0) {
            this.addParticle(new Particle(this.bird.getCenterPos(), ParticleColor.WHITE, 9, ParticleLevel.RUNNING_GAME)).setVelocity(new Vec2(-2.5f, 0.0f));
        }
        --this.pipeSpawnTimer;
    }

    @Override
    public synchronized void die() {
        super.die();
        this.bird.hide();
        this.spawnParticleExplosion(() -> new BreakParticleRenderer(new ResourceLocation("gamediscs", "textures/games/sprite/bird.png"), 10, 32), this.bird.getCenterPos(), 20, 2, 10, ParticleLevel.GAME);
    }

    private void spawnPipe() {
        int holeSize = this.random.nextInt(24, 28);
        int hole = this.random.nextInt(5, 100 - holeSize - 21);
        this.pipes.add(new Sprite(new Vec2(140.0f, (float)hole - 64.0f), new Vec2(16.0f, 64.0f), new ResourceLocation("gamediscs", "textures/games/sprite/pipe_top.png")));
        this.pipes.get(this.pipes.size() - 1).setVelocity(new Vec2(-2.5f, 0.0f));
        this.pipes.add(new Sprite(new Vec2(140.0f, (float)hole + (float)holeSize), new Vec2(16.0f, 64.0f), new ResourceLocation("gamediscs", "textures/games/sprite/pipe_bottom.png")));
        this.pipes.get(this.pipes.size() - 1).setVelocity(new Vec2(-2.5f, 0.0f));
    }

    @Override
    public synchronized void render(GuiGraphics graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        if (this.bird != null) {
            this.bird.render(graphics, posX, posY);
        }
        for (Sprite pillar : this.pipes) {
            pillar.render(graphics, posX, posY);
        }
        this.ground.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        this.renderOverlay(graphics, posX, posY);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
        if (button.isActionButton()) {
            this.bird.setVelocity(new Vec2(0.0f, -4.5f));
            if (this.stage == GameStage.PLAYING) {
                this.soundPlayer.playJump();
            }
        }
    }

    @Override
    public ResourceLocation getBackground() {
        return new ResourceLocation("gamediscs", "textures/games/background/flappy_bird_background.png");
    }

    @Override
    public boolean showScoreBox() {
        return false;
    }

    @Override
    public int scoreColor() {
        return ChatFormatting.YELLOW.m_126665_();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"gamediscs.flappy_bird");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("gamediscs", "textures/item/game_disc_flappy_bird.png");
    }
}

