/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostworlds.worldgen.wastes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mcjty.lostworlds.compat.LostCitiesCompat;
import mcjty.lostworlds.worldgen.wastes.BiomeMapper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.server.ServerLifecycleHooks;

public class WastesBiomeSource
extends BiomeSource {
    public static final Codec<WastesBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(provider -> provider.biomes), (App)Codec.STRING.fieldOf("dimension").forGetter(provider -> provider.dimensionId), (App)BiomeSource.f_47888_.fieldOf("adapt_biome_source").forGetter(provider -> provider.biomeSource), (App)Codec.STRING.optionalFieldOf("default").forGetter(provider -> Optional.ofNullable(provider.mapper.getDefaultBiomeId())), (App)Codec.STRING.optionalFieldOf("sphere_default").forGetter(provider -> Optional.ofNullable(provider.sphereMapper.getDefaultBiomeId())), (App)Codec.list((Codec)Codec.STRING).fieldOf("mapping").forGetter(provider -> provider.mapper.getBiomeMappingList()), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("sphere_mapping").forGetter(provider -> Optional.ofNullable(provider.sphereMapper.getBiomeMappingList()))).apply((Applicative)instance, instance.stable(WastesBiomeSource::new)));
    private final String dimensionId;
    private final HolderLookup.RegistryLookup<Biome> biomes;
    private final BiomeSource biomeSource;
    private final BiomeMapper mapper;
    private final BiomeMapper sphereMapper;
    private Level level;

    public WastesBiomeSource(HolderLookup.RegistryLookup<Biome> biomes, String dimensionId, BiomeSource biomeSource, Optional<String> defaultBiome, Optional<String> defaultSphereBiome, List<String> biomeMappingList, Optional<List<String>> sphereBiomeMappingList) {
        this.dimensionId = dimensionId;
        this.biomes = biomes;
        this.biomeSource = biomeSource;
        this.mapper = new BiomeMapper(biomes, defaultBiome, biomeMappingList);
        this.sphereMapper = new BiomeMapper(biomes, defaultSphereBiome, sphereBiomeMappingList.orElse(Collections.emptyList()));
    }

    @Nonnull
    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return this.biomeSource.m_207840_().stream();
    }

    @Nonnull
    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        Holder biome = this.biomeSource.m_203407_(x, y, z, sampler);
        BiomeMapper m = this.mapper;
        if (LostCitiesCompat.isHasLostCities()) {
            if (this.level == null) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                this.level = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(this.dimensionId)));
            }
            if (this.level != null && LostCitiesCompat.isInSphere(this.level, (x << 2) + 2, (z << 2) + 2)) {
                m = this.sphereMapper;
            }
        }
        return m.getMappedBiome((Holder<Biome>)biome);
    }
}

