/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostworlds.worldgen.wastes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mcjty.lostworlds.setup.ModSetup;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.StringUtils;

public class BiomeMapper {
    final HolderLookup.RegistryLookup<Biome> biomes;
    private final List<String> biomeMappingList;
    private final String defaultBiomeId;
    private final Holder<Biome> defaultBiome;
    private Map<Biome, Holder<Biome>> biomeMapping = null;

    public BiomeMapper(HolderLookup.RegistryLookup<Biome> biomes, Optional<String> defaultBiomeId, List<String> biomeMappingList) {
        this.biomes = biomes;
        this.biomeMappingList = biomeMappingList;
        this.defaultBiomeId = defaultBiomeId.orElse(null);
        if (this.defaultBiomeId == null) {
            this.defaultBiome = null;
        } else {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(this.defaultBiomeId));
            this.defaultBiome = biomes.m_255043_(key);
        }
    }

    public List<String> getBiomeMappingList() {
        return this.biomeMappingList;
    }

    public String getDefaultBiomeId() {
        return this.defaultBiomeId;
    }

    private void initBiomeMapping() {
        if (this.biomeMapping == null) {
            this.biomeMapping = new HashMap<Biome, Holder<Biome>>();
            for (String replacement : this.biomeMappingList) {
                String[] split = StringUtils.split((String)replacement, (char)'=');
                Optional source = this.biomes.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(split[0])));
                if (!source.isPresent()) {
                    ModSetup.logger.warn("Biome '" + split[0] + "' is missing!");
                    continue;
                }
                Optional dest = this.biomes.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(split[1])));
                if (!dest.isPresent()) {
                    ModSetup.logger.warn("Biome '" + split[1] + "' is missing!");
                    continue;
                }
                dest.ifPresent(h -> this.biomeMapping.put((Biome)((Holder.Reference)source.get()).get(), (Holder<Biome>)h));
            }
        }
    }

    public Holder<Biome> getMappedBiome(Holder<Biome> biome) {
        this.initBiomeMapping();
        return this.biomeMapping.getOrDefault(biome.get(), this.defaultBiome == null ? biome : this.defaultBiome);
    }
}

