/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostworlds.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcjty.lostcities.api.ILostWorldsChunkGenerator;
import mcjty.lostcities.varia.NoiseGeneratorPerlin;
import mcjty.lostworlds.compat.LostCitiesCompat;
import mcjty.lostworlds.worldgen.LWSettings;
import mcjty.lostworlds.worldgen.LostWorldType;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class LWChunkGenerator
extends NoiseBasedChunkGenerator
implements ILostWorldsChunkGenerator {
    public static final ResourceLocation LOSTWORLDS_CHUNKGEN = new ResourceLocation("lostworlds", "lostworlds");
    public static final ResourceKey<NoiseGeneratorSettings> LOST_ISLANDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("lostworlds", "lost_islands"));
    public static final ResourceKey<NoiseGeneratorSettings> LOST_CAVES = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("lostworlds", "lost_caves"));
    public static final ResourceKey<NoiseGeneratorSettings> LOST_SPHERES = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("lostworlds", "lost_spheres"));
    public static final ResourceKey<NoiseGeneratorSettings> LOST_NORMAL = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("lostworlds", "lost_normal"));
    public static final ResourceKey<NoiseGeneratorSettings> LOST_ATLANTIS = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("lostworlds", "lost_atlantis"));
    public static final ResourceKey<NoiseGeneratorSettings> LOST_CAVESPHERES = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("lostworlds", "lost_cavespheres"));
    public static final float GROUND_SCALE = 3.0f;
    private final LWSettings lwSettings;
    private final NoiseGeneratorPerlin groundNoise;
    private double[] groundBuffer = new double[256];
    private Level cachedLevel;
    public static final Codec<LWChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LWSettings.CODEC.fieldOf("lwsettings").forGetter(LWChunkGenerator::getLwSettings), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(ChunkGenerator::m_62218_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::m_224341_)).apply((Applicative)instance, instance.stable(LWChunkGenerator::new)));

    public LWChunkGenerator(LWSettings lwSettings, BiomeSource source, Holder<NoiseGeneratorSettings> settings) {
        super(source, settings);
        this.lwSettings = lwSettings;
        LegacyRandomSource rand = new LegacyRandomSource(0L);
        this.groundNoise = new NoiseGeneratorPerlin((RandomSource)rand, 4);
    }

    public LWSettings getLwSettings() {
        return this.lwSettings;
    }

    public ChunkAccess m_224284_(Blender blender, StructureManager structureManager, RandomState random, ChunkAccess chunkAccess, int minCellY, int cellCountY) {
        ChunkPos cp = chunkAccess.m_7697_();
        boolean customSea = this.lwSettings.hasCustomSea();
        if (customSea || this.lwSettings.type() == LostWorldType.CAVESPHERES) {
            this.groundBuffer = this.groundNoise.getRegion(this.groundBuffer, (double)(cp.f_45578_ * 16), (double)(cp.f_45579_ * 16), 16, 16, 0.0625, 0.0625, 1.0);
        }
        if (this.lwSettings.type() == LostWorldType.SPHERES) {
            chunkAccess = this.doFillSpheres(blender, structureManager, random, chunkAccess, minCellY, cellCountY);
        } else if (this.lwSettings.type() == LostWorldType.CAVESPHERES) {
            chunkAccess = this.doFillCaveSpheres(blender, structureManager, random, chunkAccess, minCellY, cellCountY);
        } else {
            chunkAccess = super.m_224284_(blender, structureManager, random, chunkAccess, minCellY, cellCountY);
            if (customSea) {
                this.fillCustomSea(chunkAccess, cp);
            }
        }
        return chunkAccess;
    }

    @NotNull
    private ChunkAccess doFillCaveSpheres(Blender blender, StructureManager structureManager, RandomState random, ChunkAccess chunkAccess, int minCellY, int cellCountY) {
        chunkAccess = super.m_224284_(blender, structureManager, random, chunkAccess, minCellY, cellCountY);
        ChunkPos cp = chunkAccess.m_7697_();
        WorldGenRegion region = (WorldGenRegion)structureManager.f_220460_;
        this.cachedLevel = region.m_6018_();
        LostCitiesCompat.LostCitiesContext context = LostCitiesCompat.getLostCitiesContext((Level)region.m_6018_());
        int minBuildHeight = chunkAccess.m_141937_();
        int maxBuildHeight = chunkAccess.m_151558_();
        int minSphereY = context.getMinSphereY(cp.m_45604_(), cp.m_45605_());
        int maxSphereY = context.getMaxSphereY(cp.m_45604_(), cp.m_45605_());
        BlockState defaultBlock = ((NoiseGeneratorSettings)this.m_224341_().get()).f_64440_();
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        BlockState air = Blocks.f_50016_.m_49966_();
        int middleY = (minSphereY + maxSphereY) / 2;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = this.getGroundLevel(x, z) + middleY + 15;
                for (int y = Math.max(minBuildHeight, minSphereY); y <= Math.min(maxBuildHeight - 1, maxSphereY); ++y) {
                    LevelChunkSection levelchunksection = chunkAccess.m_183278_(chunkAccess.m_151564_(y));
                    if (!context.isInSphere(cp.m_45604_() + x, y, cp.m_45605_() + z)) continue;
                    if (y < height) {
                        levelchunksection.m_62991_(x, y & 0xF, z, y < minBuildHeight + 2 ? bedrock : defaultBlock, false);
                        continue;
                    }
                    levelchunksection.m_62991_(x, y & 0xF, z, air, false);
                }
            }
        }
        return chunkAccess;
    }

    private ChunkAccess doFillSpheres(Blender blender, StructureManager structureManager, RandomState random, ChunkAccess chunkAccess, int minCellY, int cellCountY) {
        ChunkPos cp = chunkAccess.m_7697_();
        boolean customSea = this.lwSettings.hasCustomSea();
        WorldGenRegion region = (WorldGenRegion)structureManager.f_220460_;
        this.cachedLevel = region.m_6018_();
        LostCitiesCompat.LostCitiesContext context = LostCitiesCompat.getLostCitiesContext((Level)region.m_6018_());
        if (context != null && context.isInSphereFullOrPartially(cp.m_45604_(), cp.m_45605_())) {
            chunkAccess = super.m_224284_(blender, structureManager, random, chunkAccess, minCellY, cellCountY);
            int minBuildHeight = chunkAccess.m_141937_();
            int maxBuildHeight = chunkAccess.m_151558_();
            int minSphereY = context.getMinSphereY(cp.m_45604_(), cp.m_45605_());
            int maxSphereY = context.getMaxSphereY(cp.m_45604_(), cp.m_45605_());
            BlockState defaultBlock = ((NoiseGeneratorSettings)this.m_224341_().get()).f_64440_();
            BlockState bedrock = Blocks.f_50752_.m_49966_();
            BlockState air = Blocks.f_50016_.m_49966_();
            BlockState water = customSea ? Blocks.f_49990_.m_49966_() : air;
            int level = this.lwSettings.seaLevel() == null ? -63 : this.lwSettings.seaLevel();
            for (int y = minBuildHeight; y < maxBuildHeight; ++y) {
                int z;
                int x;
                BlockState block = y <= level ? water : air;
                LevelChunkSection levelchunksection = chunkAccess.m_183278_(chunkAccess.m_151564_(y));
                if (y >= minSphereY && y <= maxSphereY) {
                    for (x = 0; x < 16; ++x) {
                        for (z = 0; z < 16; ++z) {
                            if (context.isInSphere(cp.m_45604_() + x, y, cp.m_45605_() + z)) continue;
                            if (customSea && y < this.getGroundLevel(x, z)) {
                                levelchunksection.m_62991_(x, y & 0xF, z, y < minBuildHeight + 2 ? bedrock : defaultBlock, false);
                                continue;
                            }
                            levelchunksection.m_62991_(x, y & 0xF, z, block, false);
                        }
                    }
                    continue;
                }
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (customSea && y < this.getGroundLevel(x, z)) {
                            levelchunksection.m_62991_(x, y & 0xF, z, y < minBuildHeight + 2 ? bedrock : defaultBlock, false);
                            continue;
                        }
                        levelchunksection.m_62991_(x, y & 0xF, z, block, false);
                    }
                }
            }
        } else if (customSea) {
            this.fillCustomSea(chunkAccess, cp);
        }
        return chunkAccess;
    }

    private int getGroundLevel(int x, int z) {
        double vr = -15.0 + this.groundBuffer[x + z * 16] / 3.0;
        return (int)vr;
    }

    public void m_213679_(WorldGenRegion level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunk, GenerationStep.Carving step) {
        if (this.lwSettings.type() == LostWorldType.CAVES || this.lwSettings.type() == LostWorldType.NORMAL || this.lwSettings.type() == LostWorldType.ATLANTIS || this.lwSettings.type() == LostWorldType.CAVESPHERES) {
            super.m_213679_(level, seed, random, biomeManager, structureManager, chunk, step);
        } else if (this.lwSettings.type() == LostWorldType.SPHERES) {
            ChunkPos cp = chunk.m_7697_();
            WorldGenRegion region = (WorldGenRegion)structureManager.f_220460_;
            this.cachedLevel = region.m_6018_();
            LostCitiesCompat.LostCitiesContext context = LostCitiesCompat.getLostCitiesContext((Level)region.m_6018_());
            if (this.lwSettings.hasCustomSea()) {
                if (context != null && context.isInSphereFull(cp.m_45604_(), cp.m_45605_())) {
                    super.m_213679_(level, seed, random, biomeManager, structureManager, chunk, step);
                }
            } else if (context != null && context.isInSphereFullOrPartially(cp.m_45604_(), cp.m_45605_())) {
                super.m_213679_(level, seed, random, biomeManager, structureManager, chunk, step);
            }
        }
    }

    private void fillCustomSea(ChunkAccess chunkAccess, ChunkPos cp) {
        Heightmap heightmap = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        BlockState defaultBlock = ((NoiseGeneratorSettings)this.m_224341_().get()).f_64440_();
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        BlockState water = Blocks.f_49990_.m_49966_();
        BlockState air = Blocks.f_50016_.m_49966_();
        int minBuildHeight = chunkAccess.m_141937_();
        if (this.lwSettings.type() == LostWorldType.ISLANDS) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int vr = this.getGroundLevel(x, z);
                    for (int y = minBuildHeight; y <= this.lwSettings.seaLevel(); ++y) {
                        BlockState b = y < vr ? (y < minBuildHeight + 2 ? bedrock : defaultBlock) : water;
                        LevelChunkSection levelchunksection = chunkAccess.m_183278_(chunkAccess.m_151564_(y));
                        if (levelchunksection.m_62982_(x, y & 0xF, z) != air) continue;
                        levelchunksection.m_62991_(x, y & 0xF, z, b, false);
                        heightmap.m_64249_(x, y, z, b);
                        heightmap1.m_64249_(x, y, z, b);
                    }
                }
            }
        } else {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int vr = this.getGroundLevel(x, z);
                    for (int y = minBuildHeight; y <= this.lwSettings.seaLevel(); ++y) {
                        BlockState b = y < vr ? (y < minBuildHeight + 2 ? bedrock : defaultBlock) : water;
                        LevelChunkSection levelchunksection = chunkAccess.m_183278_(chunkAccess.m_151564_(y));
                        levelchunksection.m_62991_(x, y & 0xF, z, b, false);
                        heightmap.m_64249_(x, y, z, b);
                        heightmap1.m_64249_(x, y, z, b);
                    }
                }
            }
        }
    }

    public int m_214096_(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState random) {
        LostCitiesCompat.LostCitiesContext context;
        if (this.lwSettings.type() == LostWorldType.SPHERES && this.cachedLevel != null && (context = LostCitiesCompat.getLostCitiesContext(this.cachedLevel)) != null && !context.isInSphereFullOrPartially(x << 4, z << 4)) {
            return level.m_141937_();
        }
        return super.m_214096_(x, z, type, level, random);
    }

    public void m_224261_(ChunkAccess chunkAccess, WorldGenerationContext wgContext, RandomState random, StructureManager structureManager, BiomeManager biomeManager, Registry<Biome> biomes, Blender blender) {
        if (this.lwSettings.type() == LostWorldType.SPHERES) {
            ChunkPos cp = chunkAccess.m_7697_();
            boolean customSea = this.lwSettings.hasCustomSea();
            if (customSea) {
                this.groundBuffer = this.groundNoise.getRegion(this.groundBuffer, (double)(cp.f_45578_ * 16), (double)(cp.f_45579_ * 16), 16, 16, 0.0625, 0.0625, 1.0);
            }
            BlockState air = Blocks.f_50016_.m_49966_();
            BlockState water = customSea ? Blocks.f_49990_.m_49966_() : air;
            BlockState defaultBlock = ((NoiseGeneratorSettings)this.m_224341_().get()).f_64440_();
            BlockState bedrock = Blocks.f_50752_.m_49966_();
            WorldGenRegion region = (WorldGenRegion)structureManager.f_220460_;
            this.cachedLevel = region.m_6018_();
            LostCitiesCompat.LostCitiesContext context = LostCitiesCompat.getLostCitiesContext((Level)region.m_6018_());
            if (context != null) {
                if (context.isInSphereFull(cp.m_45604_(), cp.m_45605_())) {
                    super.m_224261_(chunkAccess, wgContext, random, structureManager, biomeManager, biomes, blender);
                } else if (context.isInSphereFullOrPartially(cp.m_45604_(), cp.m_45605_())) {
                    super.m_224261_(chunkAccess, wgContext, random, structureManager, biomeManager, biomes, blender);
                    int minBuildHeight = chunkAccess.m_141937_();
                    int maxBuildHeight = chunkAccess.m_151558_();
                    int minSphereY = context.getMinSphereY(cp.m_45604_(), cp.m_45605_());
                    int maxSphereY = context.getMaxSphereY(cp.m_45604_(), cp.m_45605_());
                    int level = this.lwSettings.seaLevel() == null ? -63 : this.lwSettings.seaLevel();
                    for (int y = minBuildHeight; y < maxBuildHeight; ++y) {
                        int z;
                        int x;
                        BlockState block = y <= level ? water : air;
                        LevelChunkSection levelchunksection = chunkAccess.m_183278_(chunkAccess.m_151564_(y));
                        if (y >= minSphereY && y <= maxSphereY) {
                            for (x = 0; x < 16; ++x) {
                                for (z = 0; z < 16; ++z) {
                                    if (context.isInSphere(cp.m_45604_() + x, y, cp.m_45605_() + z)) continue;
                                    if (customSea && y < this.getGroundLevel(x, z)) {
                                        levelchunksection.m_62991_(x, y & 0xF, z, y < minBuildHeight + 2 ? bedrock : defaultBlock, false);
                                        continue;
                                    }
                                    levelchunksection.m_62991_(x, y & 0xF, z, block, false);
                                }
                            }
                            continue;
                        }
                        for (x = 0; x < 16; ++x) {
                            for (z = 0; z < 16; ++z) {
                                if (customSea && y < this.getGroundLevel(x, z)) {
                                    levelchunksection.m_62991_(x, y & 0xF, z, y < minBuildHeight + 2 ? bedrock : defaultBlock, false);
                                    continue;
                                }
                                levelchunksection.m_62991_(x, y & 0xF, z, block, false);
                            }
                        }
                    }
                }
                return;
            }
        }
        super.m_224261_(chunkAccess, wgContext, random, structureManager, biomeManager, biomes, blender);
    }

    public void m_255037_(RegistryAccess access, ChunkGeneratorStructureState structureState, StructureManager structureManager, ChunkAccess chunk, StructureTemplateManager templateManager) {
        LevelAccessor levelAccessor = structureManager.f_220460_;
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            this.cachedLevel = serverLevel;
        } else {
            levelAccessor = structureManager.f_220460_;
            if (levelAccessor instanceof WorldGenRegion) {
                WorldGenRegion region = (WorldGenRegion)levelAccessor;
                this.cachedLevel = region.m_6018_();
            }
        }
        ChunkPos cp = chunk.m_7697_();
        SectionPos sectionpos = SectionPos.m_175562_((ChunkAccess)chunk);
        RandomState randomstate = structureState.m_255046_();
        structureState.m_255252_().forEach(set -> {
            StructurePlacement structureplacement = ((StructureSet)set.m_203334_()).f_210004_();
            List list = ((StructureSet)set.m_203334_()).f_210003_();
            ResourceKey key = (ResourceKey)set.m_203543_().get();
            if (this.lwSettings.type().blocksStructure((ResourceKey<StructureSet>)key)) {
                return;
            }
            for (StructureSet.StructureSelectionEntry entry : list) {
                StructureStart structurestart = structureManager.m_220512_(sectionpos, (Structure)entry.f_210026_().m_203334_(), (StructureAccess)chunk);
                if (structurestart == null || !structurestart.m_73603_()) continue;
                return;
            }
            if (structureplacement.m_255071_(structureState, cp.f_45578_, cp.f_45579_)) {
                if (list.size() == 1) {
                    this.tryGenerateStructure((StructureSet.StructureSelectionEntry)list.get(0), structureManager, access, randomstate, templateManager, structureState.m_254887_(), chunk, cp, sectionpos);
                } else {
                    ArrayList listCopy = new ArrayList(list);
                    WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
                    worldgenrandom.m_190068_(structureState.m_254887_(), cp.f_45578_, cp.f_45579_);
                    int totalweight = 0;
                    for (StructureSet.StructureSelectionEntry entry : listCopy) {
                        totalweight += entry.f_210027_();
                    }
                    while (!listCopy.isEmpty()) {
                        StructureSet.StructureSelectionEntry entry;
                        int w = worldgenrandom.m_188503_(totalweight);
                        int selected = 0;
                        Iterator iterator = listCopy.iterator();
                        while (iterator.hasNext() && (w -= (entry = (StructureSet.StructureSelectionEntry)iterator.next()).f_210027_()) >= 0) {
                            ++selected;
                        }
                        StructureSet.StructureSelectionEntry entry2 = (StructureSet.StructureSelectionEntry)listCopy.get(selected);
                        if (this.tryGenerateStructure(entry2, structureManager, access, randomstate, templateManager, structureState.m_254887_(), chunk, cp, sectionpos)) {
                            return;
                        }
                        listCopy.remove(selected);
                        totalweight -= entry2.f_210027_();
                    }
                }
            }
        });
    }

    private boolean tryGenerateStructure(StructureSet.StructureSelectionEntry entry, StructureManager structureManager, RegistryAccess registryAccess, RandomState rnd, StructureTemplateManager templateManager, long seed, ChunkAccess chunk, ChunkPos cp, SectionPos sp) {
        Structure structure = (Structure)entry.f_210026_().m_203334_();
        StructureStart start = structureManager.m_220512_(sp, structure, (StructureAccess)chunk);
        int references = start != null ? start.m_73608_() : 0;
        StructureStart structurestart = structure.m_226596_(registryAccess, (ChunkGenerator)this, this.f_62137_, rnd, templateManager, seed, cp, references, (LevelHeightAccessor)chunk, arg_0 -> ((HolderSet)structure.m_226559_()).m_203333_(arg_0));
        if (structurestart.m_73603_()) {
            structureManager.m_220516_(sp, structure, structurestart, (StructureAccess)chunk);
            return true;
        }
        return false;
    }

    public int m_6337_() {
        if (this.lwSettings.hasCustomSea()) {
            return this.lwSettings.seaLevel();
        }
        return super.m_6337_();
    }

    public Integer getOuterSeaLevel() {
        return this.lwSettings.seaLevel();
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }
}

