/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostworlds.network;

import java.util.function.Supplier;
import mcjty.lostworlds.client.LostWorldsSpecialEffects;
import mcjty.lostworlds.worldgen.FogColor;
import mcjty.lostworlds.worldgen.LostWorldType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketWorldInfoToClient {
    private final LostWorldType type;
    private final FogColor fogColor;
    private final boolean disabled;

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeShort(this.type.ordinal());
        buf.writeShort(this.fogColor.ordinal());
        buf.writeBoolean(this.disabled);
    }

    public PacketWorldInfoToClient(FriendlyByteBuf buf) {
        this.type = LostWorldType.values()[buf.readShort()];
        this.fogColor = FogColor.values()[buf.readShort()];
        this.disabled = buf.readBoolean();
    }

    public PacketWorldInfoToClient(LostWorldType type, FogColor fogColor, boolean disabled) {
        this.type = type;
        this.fogColor = fogColor;
        this.disabled = disabled;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            LostWorldsSpecialEffects.type = this.type;
            LostWorldsSpecialEffects.fogColor = this.fogColor;
            LostWorldsSpecialEffects.disabled = this.disabled;
        });
        ctx.setPacketHandled(true);
    }
}

