/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostworlds.compat;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostCities;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.lostcities.api.ILostSphere;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public class LostCitiesCompat {
    private static boolean hasLostCities = false;
    private static ILostCities lostCities;

    public static boolean isInSphere(Level level, int x, int z) {
        if (!hasLostCities) {
            return false;
        }
        ILostCityInformation lostInfo = lostCities.getLostInfo(level);
        if (lostInfo == null) {
            return false;
        }
        ILostSphere sphere = lostInfo.getSphere(x, z);
        if (sphere == null) {
            return false;
        }
        if (!sphere.isEnabled()) {
            return false;
        }
        double sqdist = sphere.getCenterPos().m_203198_((double)x, (double)sphere.getCenterPos().m_123342_(), (double)z);
        double dist = Math.sqrt(sqdist);
        return dist < (double)(sphere.getRadius() - 5.0f);
    }

    public static void setProfile(String profile) {
        if (!hasLostCities) {
            return;
        }
        lostCities.setOverworldProfile(profile);
    }

    public static void register() {
        if (ModList.get().isLoaded("lostcities")) {
            InterModComms.sendTo((String)"lostcities", (String)"getLostCities", GetLostCities::new);
        }
    }

    public static boolean isHasLostCities() {
        return hasLostCities;
    }

    public static LostCitiesContext getLostCitiesContext(Level level) {
        if (!hasLostCities) {
            return null;
        }
        ILostCityInformation info = lostCities.getLostInfo(level);
        if (info != null) {
            return new LostCitiesContext(info);
        }
        return null;
    }

    public static class LostCitiesContext {
        private final ILostCityInformation info;

        public LostCitiesContext(ILostCityInformation info) {
            this.info = info;
        }

        private ILostSphere findSphere(int x, int z) {
            ILostSphere sphere = this.info.getSphere(x, z);
            if (sphere == null && (sphere = this.info.getSphere(x + 15, z)) == null && (sphere = this.info.getSphere(x, z + 15)) == null) {
                sphere = this.info.getSphere(x + 15, z + 15);
            }
            return sphere;
        }

        private ILostSphere findSphereFull(int x, int z) {
            ILostSphere sphere = this.info.getSphere(x, z);
            if (sphere != null && (sphere = this.info.getSphere(x + 15, z)) != null && (sphere = this.info.getSphere(x, z + 15)) != null) {
                sphere = this.info.getSphere(x + 15, z + 15);
            }
            return sphere;
        }

        public boolean isInSphereFullOrPartially(int x, int z) {
            ILostSphere sphere = this.findSphere(x, z);
            return sphere != null;
        }

        public boolean isInSphereFull(int x, int z) {
            ILostSphere sphere = this.findSphereFull(x, z);
            return sphere != null;
        }

        public boolean isInSphere(int x, int y, int z) {
            float radius;
            int dz;
            int dy;
            BlockPos center;
            int dx;
            ILostSphere sphere = this.info.getSphere(x, y, z);
            return sphere != null && (float)((dx = x - (center = sphere.getCenterPos()).m_123341_()) * dx + (dy = y - center.m_123342_()) * dy + (dz = z - center.m_123343_()) * dz) < (radius = sphere.getRadius() - 1.0f) * radius;
        }

        public int getMinSphereY(int x, int z) {
            ILostSphere sphere = this.findSphere(x, z);
            if (sphere != null) {
                return sphere.getCenterPos().m_123342_() - (int)sphere.getRadius() - 1;
            }
            return -4000;
        }

        public int getMaxSphereY(int x, int z) {
            ILostSphere sphere = this.findSphere(x, z);
            if (sphere != null) {
                return sphere.getCenterPos().m_123342_() + (int)sphere.getRadius() + 1;
            }
            return 4000;
        }
    }

    public static class GetLostCities
    implements Function<ILostCities, Void> {
        @Override
        @Nullable
        public Void apply(ILostCities lc) {
            lostCities = lc;
            hasLostCities = true;
            return null;
        }
    }
}

