/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostworlds.client;

import java.util.function.BiConsumer;
import mcjty.lostworlds.compat.LostCitiesCompat;
import mcjty.lostworlds.worldgen.FogColor;
import mcjty.lostworlds.worldgen.LWChunkGenerator;
import mcjty.lostworlds.worldgen.LWSettings;
import mcjty.lostworlds.worldgen.LostWorldType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.NotNull;

public class LWScreen
extends Screen {
    private final CreateWorldScreen parent;
    private final BiConsumer<NoiseGeneratorSettings, LWSettings> applySettings;
    private NoiseGeneratorSettings generator;
    private LWSettings lwSettings;
    private final HolderGetter<NoiseGeneratorSettings> noisegetter;
    private static final SelectedSetting NORMAL = new SelectedSetting(LostWorldType.NORMAL, LWChunkGenerator.LOST_NORMAL, "icon_normal.png", "createWorld.customize.lostworlds.normal.description", "biosphere");
    private static final SelectedSetting ATLANTIS = new SelectedSetting(LostWorldType.ATLANTIS, LWChunkGenerator.LOST_ATLANTIS, "icon_atlantis.png", "createWorld.customize.lostworlds.atlantis.description", "atlantis");
    private static final SelectedSetting ISLANDS = new SelectedSetting(LostWorldType.ISLANDS, LWChunkGenerator.LOST_ISLANDS, "icon_islands.png", "createWorld.customize.lostworlds.islands.description", "floating");
    private static final SelectedSetting CAVES = new SelectedSetting(LostWorldType.CAVES, LWChunkGenerator.LOST_CAVES, "icon_caves.png", "createWorld.customize.lostworlds.caves.description", "caves");
    private static final SelectedSetting SPHERES = new SelectedSetting(LostWorldType.SPHERES, LWChunkGenerator.LOST_SPHERES, "icon_spheres.png", "createWorld.customize.lostworlds.spheres.description", "space");
    private static final SelectedSetting CAVESPHERES = new SelectedSetting(LostWorldType.CAVESPHERES, LWChunkGenerator.LOST_CAVESPHERES, "icon_cavespheres.png", "createWorld.customize.lostworlds.cavespheres.description", "biosphere");
    private SelectedSetting selected = ISLANDS;
    private Button islandsButton;
    private Button normalButton;
    private Button cavesButton;
    private Button spheresButton;
    private Button atlantisButton;
    private Button cavespheresButton;
    private CycleButton<FogColor> fogColorButton;
    private ForgeSlider seaLevelSlider;

    public LWScreen(CreateWorldScreen worldScreen, HolderGetter<NoiseGeneratorSettings> noisegetter, BiConsumer<NoiseGeneratorSettings, LWSettings> settingsConsumer, NoiseGeneratorSettings generator, LWSettings lwSettings) {
        super((Component)Component.m_237115_((String)"createWorld.customize.lostworlds.title"));
        this.parent = worldScreen;
        this.applySettings = settingsConsumer;
        this.generator = generator;
        this.lwSettings = lwSettings;
        this.noisegetter = noisegetter;
    }

    protected void m_7856_() {
        this.islandsButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"createWorld.customize.lostworlds.islands"), button -> {
            this.selected = ISLANDS;
        }).m_252987_(5, this.f_96544_ - 56, 65, 20).m_253136_());
        this.cavesButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"createWorld.customize.lostworlds.caves"), button -> {
            this.selected = CAVES;
        }).m_252987_(75, this.f_96544_ - 56, 65, 20).m_253136_());
        this.spheresButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"createWorld.customize.lostworlds.spheres"), button -> {
            this.selected = SPHERES;
        }).m_252987_(145, this.f_96544_ - 56, 65, 20).m_253136_());
        this.normalButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"createWorld.customize.lostworlds.normal"), button -> {
            this.selected = NORMAL;
        }).m_252987_(215, this.f_96544_ - 56, 65, 20).m_253136_());
        this.atlantisButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"createWorld.customize.lostworlds.atlantis"), button -> {
            this.selected = ATLANTIS;
        }).m_252987_(285, this.f_96544_ - 56, 65, 20).m_253136_());
        this.cavespheresButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"createWorld.customize.lostworlds.cavespheres"), button -> {
            this.selected = CAVESPHERES;
        }).m_252987_(355, this.f_96544_ - 56, 65, 20).m_253136_());
        this.selected = switch (this.lwSettings.type()) {
            case LostWorldType.ISLANDS -> ISLANDS;
            case LostWorldType.CAVES -> CAVES;
            case LostWorldType.SPHERES -> SPHERES;
            case LostWorldType.ATLANTIS -> ATLANTIS;
            case LostWorldType.CAVESPHERES -> CAVESPHERES;
            default -> NORMAL;
        };
        this.fogColorButton = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168894_(t -> Component.m_237113_((String)t.m_7912_())).m_168961_((Object[])FogColor.values()).m_168930_(10, 80, 70, 20, (Component)Component.m_237113_((String)"Fog")));
        this.fogColorButton.m_168892_((Object)this.lwSettings.fogColor());
        this.seaLevelSlider = (ForgeSlider)this.m_142416_((GuiEventListener)new ForgeSlider(10, 110, 220, 20, (Component)Component.m_237113_((String)"Sea "), (Component)Component.m_237113_((String)""), -64.0, 384.0, 0.0, 1.0, 1, true){

            public String getValueString() {
                if (this.getValue() == -64.0) {
                    return "Off";
                }
                return super.getValueString();
            }
        });
        this.seaLevelSlider.m_93611_(this.lwSettings.seaLevel() == null ? -64.0 : (double)this.lwSettings.seaLevel().intValue());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            Holder.Reference gen = this.noisegetter.m_255043_(this.selected.settingsKey());
            this.generator = (NoiseGeneratorSettings)gen.get();
            LWSettings lwSettings = this.createNewLwSettings();
            this.applySettings.accept(this.generator, lwSettings);
            this.f_96541_.m_91152_((Screen)this.parent);
            LostCitiesCompat.setProfile(this.selected.profile());
        }).m_252987_(this.f_96543_ - 130, this.f_96544_ - 28, 50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_((Screen)this.parent)).m_252987_(this.f_96543_ - 70, this.f_96544_ - 28, 50, 20).m_253136_());
    }

    @NotNull
    private LWSettings createNewLwSettings() {
        return new LWSettings(this.selected.type(), (FogColor)((Object)this.fogColorButton.m_168883_()), this.seaLevelSlider.getValue() == -64.0 ? null : Integer.valueOf((int)this.seaLevelSlider.getValue()));
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.islandsButton.setFGColor(this.selected == ISLANDS ? 0x44FF44 : 0xAAAAAA);
        this.cavesButton.setFGColor(this.selected == CAVES ? 0x44FF44 : 0xAAAAAA);
        this.spheresButton.setFGColor(this.selected == SPHERES ? 0x44FF44 : 0xAAAAAA);
        this.normalButton.setFGColor(this.selected == NORMAL ? 0x44FF44 : 0xAAAAAA);
        this.atlantisButton.setFGColor(this.selected == ATLANTIS ? 0x44FF44 : 0xAAAAAA);
        this.cavespheresButton.setFGColor(this.selected == CAVESPHERES ? 0x44FF44 : 0xAAAAAA);
        this.seaLevelSlider.f_93623_ = this.selected.type.supportsCustomSea();
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)this.selected.description), 20, 40, this.f_96543_ - 150, 0xFFFFFF);
        graphics.m_280411_(new ResourceLocation("lostworlds", "textures/gui/" + this.selected.iconName), this.f_96543_ - 120, 40, 100, 100, 0.0f, 0.0f, 128, 128, 128, 128);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    record SelectedSetting(LostWorldType type, ResourceKey<NoiseGeneratorSettings> settingsKey, String iconName, String description, String profile) {
    }
}

