/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostworlds.client;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mcjty.lostworlds.client.LWScreen;
import mcjty.lostworlds.worldgen.LWChunkGenerator;
import mcjty.lostworlds.worldgen.LWSettings;
import mcjty.lostworlds.worldgen.LostWorldType;
import mcjty.lostworlds.worldgen.wastes.WastesBiomeSource;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public class LWPresetEditor
implements PresetEditor {
    private final boolean wastes;

    public LWPresetEditor(boolean wastes) {
        this.wastes = wastes;
    }

    public Screen m_232976_(CreateWorldScreen worldScreen, WorldCreationContext context) {
        ChunkGenerator chunkgenerator = context.f_243796_().m_246737_();
        RegistryAccess.Frozen registryaccess = context.m_246480_();
        HolderLookup.RegistryLookup noisegetter = registryaccess.m_255025_(Registries.f_256932_);
        return new LWScreen(worldScreen, (HolderGetter<NoiseGeneratorSettings>)noisegetter, (settings, lwSettings) -> worldScreen.m_267748_().m_267717_(this.lostWorldsConfigurator((NoiseGeneratorSettings)settings, (LWSettings)lwSettings)), chunkgenerator instanceof LWChunkGenerator ? (NoiseGeneratorSettings)((LWChunkGenerator)chunkgenerator).m_224341_().get() : NoiseGeneratorSettings.m_238396_(), chunkgenerator instanceof LWChunkGenerator ? ((LWChunkGenerator)chunkgenerator).getLwSettings() : new LWSettings(LostWorldType.ISLANDS, null, null));
    }

    private WorldCreationContext.DimensionsUpdater lostWorldsConfigurator(NoiseGeneratorSettings settings, LWSettings lwSettings) {
        return (frozen, dimensions) -> {
            Holder.Reference params = frozen.m_175515_(Registries.f_273919_).m_246971_(MultiNoiseBiomeSourceParameterLists.f_273878_);
            Object biomesource = MultiNoiseBiomeSource.m_274591_((Holder)params);
            if (this.wastes) {
                HolderLookup.RegistryLookup registry = frozen.m_175515_(Registries.f_256952_).m_255303_();
                biomesource = new WastesBiomeSource((HolderLookup.RegistryLookup<Biome>)registry, "minecraft:overworld", (BiomeSource)biomesource, Optional.of("minecraft:desert"), Optional.of("minecraft:jungle"), LWPresetEditor.getBiomeMappingList(), Optional.empty());
            }
            LWChunkGenerator chunkgenerator = new LWChunkGenerator(lwSettings, (BiomeSource)biomesource, (Holder<NoiseGeneratorSettings>)Holder.m_205709_((Object)settings));
            return dimensions.m_246747_((RegistryAccess)frozen, (ChunkGenerator)chunkgenerator);
        };
    }

    private static List<String> getBiomeMappingList() {
        return Arrays.asList("minecraft:badlands=minecraft:badlands", "minecraft:bamboo_jungle=minecraft:wooded_badlands", "minecraft:beach=minecraft:beach", "minecraft:birch_forest=minecraft:wooded_badlands", "minecraft:cold_ocean=minecraft:cold_ocean", "minecraft:crimson_forest=minecraft:wooded_badlands", "minecraft:dark_forest=minecraft:wooded_badlands", "minecraft:deep_dark=minecraft:deep_dark", "minecraft:deep_frozen_ocean=minecraft:deep_frozen_ocean", "minecraft:deep_lukewarm_ocean=minecraft:deep_lukewarm_ocean", "minecraft:deep_ocean=minecraft:deep_ocean", "minecraft:dripstone_caves=minecraft:dripstone_caves", "minecraft:end_barrens=minecraft:end_barrens", "minecraft:end_highlands=minecraft:end_highlands", "minecraft:end_midlands=minecraft:end_midlands", "minecraft:eroded_badlands=minecraft:eroded_badlands", "minecraft:flower_forest=minecraft:wooded_badlands", "minecraft:forest=minecraft:wooded_badlands", "minecraft:frozen_ocean=minecraft:frozen_ocean", "minecraft:frozen_peaks=minecraft:frozen_peaks", "minecraft:frozen_river=minecraft:frozen_river", "minecraft:ice_spikes=minecraft:ice_spikes", "minecraft:jagged_peaks=minecraft:jagged_peaks", "minecraft:jungle=minecraft:wooded_badlands", "minecraft:lukewarm_ocean=minecraft:lukewarm_ocean", "minecraft:lush_caves=minecraft:dripstone_caves", "minecraft:nether_wastes=minecraft:nether_wastes", "minecraft:ocean=minecraft:ocean", "minecraft:old_growth_birch_forest=minecraft:wooded_badlands", "minecraft:old_growth_pine_taiga=minecraft:wooded_badlands", "minecraft:old_growth_spruce_taiga=minecraft:wooded_badlands", "minecraft:savanna=minecraft:savanna", "minecraft:savanna_plateau=minecraft:savanna_plateau", "minecraft:small_end_islands=minecraft:small_end_islands", "minecraft:soul_sand_valley=minecraft:soul_sand_valley", "minecraft:stony_peaks=minecraft:windswept_gravelly_hills", "minecraft:the_end=minecraft:the_end", "minecraft:the_void=minecraft:the_void", "minecraft:warm_ocean=minecraft:warm_ocean", "minecraft:warped_forest=minecraft:wooded_badlands", "minecraft:windswept_forest=minecraft:wooded_badlands", "minecraft:windswept_gravelly_hills=minecraft:windswept_gravelly_hills", "minecraft:windswept_hills=minecraft:windswept_hills", "minecraft:windswept_savanna=minecraft:windswept_savanna", "minecraft:wooded_badlands=minecraft:wooded_badlands");
    }
}

