/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostworlds;

import mcjty.lostworlds.network.PacketWorldInfoToClient;
import mcjty.lostworlds.setup.Messages;
import mcjty.lostworlds.worldgen.FogColor;
import mcjty.lostworlds.worldgen.LWChunkGenerator;
import mcjty.lostworlds.worldgen.LostWorldType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EventHandlers {
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ChunkGenerator chunkGenerator = ((ServerLevel)player.m_9236_()).m_7726_().m_8481_();
            if (chunkGenerator instanceof LWChunkGenerator) {
                LWChunkGenerator generator = (LWChunkGenerator)chunkGenerator;
                LostWorldType type = generator.getLwSettings().type();
                FogColor fogColor = generator.getLwSettings().fogColor();
                Messages.sendToPlayer(new PacketWorldInfoToClient(type, fogColor, false), (Player)player);
            } else {
                Messages.sendToPlayer(new PacketWorldInfoToClient(LostWorldType.NORMAL, FogColor.NONE, true), (Player)player);
            }
        }
    }

    public static void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ChunkGenerator chunkGenerator = ((ServerLevel)player.m_9236_()).m_7726_().m_8481_();
            if (chunkGenerator instanceof LWChunkGenerator) {
                LWChunkGenerator generator = (LWChunkGenerator)chunkGenerator;
                LostWorldType type = generator.getLwSettings().type();
                FogColor fogColor = generator.getLwSettings().fogColor();
                Messages.sendToPlayer(new PacketWorldInfoToClient(type, fogColor, false), (Player)player);
            } else {
                Messages.sendToPlayer(new PacketWorldInfoToClient(LostWorldType.NORMAL, FogColor.NONE, true), (Player)player);
            }
        }
    }
}

