/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class MobSettings {
    public static final Codec<RL> RL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(RL::name), (App)Codec.FLOAT.fieldOf("weight").forGetter(RL::weight)).apply((Applicative)instance, RL::new));
    public static final Codec<Effect> EFFECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(Effect::name), (App)Codec.INT.fieldOf("level").forGetter(Effect::level), (App)Codec.FLOAT.fieldOf("weight").forGetter(Effect::weight)).apply((Applicative)instance, Effect::new));
    public static final Codec<Range<Double>> DOUBLE_RANGE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("min").forGetter(Range::min), (App)Codec.DOUBLE.fieldOf("max").forGetter(Range::max)).apply((Applicative)instance, Range::new));
    public static final Codec<Range<Integer>> INT_RANGE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(Range::min), (App)Codec.INT.fieldOf("max").forGetter(Range::max)).apply((Applicative)instance, Range::new));
    public static final Codec<MobSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("buildings").forGetter(s -> new ArrayList<ResourceLocation>(s.buildings)), (App)ResourceLocation.f_135803_.listOf().fieldOf("multibuildings").forGetter(s -> new ArrayList<ResourceLocation>(s.multiBuildings)), (App)RL_CODEC.listOf().optionalFieldOf("mobs").forGetter(l -> Optional.ofNullable(l.mobs)), (App)RL_CODEC.listOf().optionalFieldOf("weapons").forGetter(l -> Optional.ofNullable(l.weapons)), (App)RL_CODEC.listOf().optionalFieldOf("helmets").forGetter(l -> Optional.ofNullable(l.helmets)), (App)RL_CODEC.listOf().optionalFieldOf("chestplates").forGetter(l -> Optional.ofNullable(l.chestplates)), (App)RL_CODEC.listOf().optionalFieldOf("leggings").forGetter(l -> Optional.ofNullable(l.leggings)), (App)RL_CODEC.listOf().optionalFieldOf("boots").forGetter(l -> Optional.ofNullable(l.boots)), (App)EFFECT_CODEC.listOf().optionalFieldOf("effects").forGetter(l -> Optional.ofNullable(l.effects)), (App)DOUBLE_RANGE_CODEC.optionalFieldOf("healthbonus").forGetter(l -> Optional.ofNullable(l.healthBonus)), (App)DOUBLE_RANGE_CODEC.optionalFieldOf("damagebonus").forGetter(l -> Optional.ofNullable(l.damageBonus)), (App)INT_RANGE_CODEC.optionalFieldOf("mobamounts").forGetter(l -> Optional.ofNullable(l.mobAmounts)), (App)Codec.DOUBLE.optionalFieldOf("hauntedchance").forGetter(l -> Optional.ofNullable(l.hauntedChance))).apply((Applicative)instance, MobSettings::new));
    private final Set<ResourceLocation> buildings;
    private final Set<ResourceLocation> multiBuildings;
    private final List<RL> mobs;
    private final List<RL> weapons;
    private final List<RL> helmets;
    private final List<RL> chestplates;
    private final List<RL> leggings;
    private final List<RL> boots;
    private final List<Effect> effects;
    private final Range<Double> healthBonus;
    private final Range<Double> damageBonus;
    private final Range<Integer> mobAmounts;
    private final Double hauntedChance;

    public MobSettings(List<ResourceLocation> buildings, List<ResourceLocation> multiBuildings, Optional<List<RL>> mobs, Optional<List<RL>> weapons, Optional<List<RL>> helmets, Optional<List<RL>> chestplates, Optional<List<RL>> leggings, Optional<List<RL>> boots, Optional<List<Effect>> effects, Optional<Range<Double>> healthBonus, Optional<Range<Double>> damageBonus, Optional<Range<Integer>> mobAmounts, Optional<Double> hauntedChance) {
        this.buildings = new HashSet<ResourceLocation>(buildings);
        this.multiBuildings = new HashSet<ResourceLocation>(multiBuildings);
        this.mobs = mobs.orElse(null);
        this.weapons = weapons.orElse(null);
        this.helmets = helmets.orElse(null);
        this.chestplates = chestplates.orElse(null);
        this.leggings = leggings.orElse(null);
        this.boots = boots.orElse(null);
        this.effects = effects.orElse(null);
        this.healthBonus = healthBonus.orElse(null);
        this.damageBonus = damageBonus.orElse(null);
        this.mobAmounts = mobAmounts.orElse(null);
        this.hauntedChance = hauntedChance.orElse(null);
    }

    @Nonnull
    public Set<ResourceLocation> getBuildings() {
        return this.buildings;
    }

    @Nonnull
    public Set<ResourceLocation> getMultiBuildings() {
        return this.multiBuildings;
    }

    @Nullable
    public List<RL> getMobs() {
        return this.mobs;
    }

    @Nullable
    public List<RL> getHelmets() {
        return this.helmets;
    }

    @Nullable
    public List<RL> getWeapons() {
        return this.weapons;
    }

    @Nullable
    public List<RL> getChestplates() {
        return this.chestplates;
    }

    @Nullable
    public List<RL> getLeggings() {
        return this.leggings;
    }

    @Nullable
    public List<RL> getBoots() {
        return this.boots;
    }

    @Nullable
    public List<Effect> getEffects() {
        return this.effects;
    }

    @Nullable
    public Range<Double> getHealthBonus() {
        return this.healthBonus;
    }

    @Nullable
    public Range<Double> getDamageBonus() {
        return this.damageBonus;
    }

    @Nullable
    public Range<Integer> getMobAmounts() {
        return this.mobAmounts;
    }

    @Nullable
    public Double getHauntedChance() {
        return this.hauntedChance;
    }

    public static MobSettings merge(MobSettings base, MobSettings override) {
        return new MobSettings(new ArrayList<ResourceLocation>(override.buildings), new ArrayList<ResourceLocation>(override.multiBuildings), Optional.of(override.mobs == null ? base.mobs : override.mobs), Optional.of(override.weapons == null ? base.weapons : override.weapons), Optional.of(override.helmets == null ? base.helmets : override.helmets), Optional.of(override.chestplates == null ? base.chestplates : override.chestplates), Optional.of(override.leggings == null ? base.leggings : override.leggings), Optional.of(override.boots == null ? base.boots : override.boots), Optional.of(override.effects == null ? base.effects : override.effects), Optional.of(override.healthBonus == null ? base.healthBonus : override.healthBonus), Optional.of(override.damageBonus == null ? base.damageBonus : override.damageBonus), Optional.of(override.mobAmounts == null ? base.mobAmounts : override.mobAmounts), Optional.ofNullable(override.hauntedChance == null ? base.hauntedChance : override.hauntedChance));
    }

    public record Range<T>(T min, T max) {
    }

    public record Effect(ResourceLocation name, int level, float weight) {
    }

    public record RL(ResourceLocation name, float weight) {
    }
}

