/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls.data;

import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lostsouls.data.MobSettings;
import mcjty.lostsouls.varia.ChunkCoord;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;

public class LostChunkData {
    private boolean haunted;
    private int totalMobs;
    private int numberKilled = 0;
    private int enteredCount = 0;
    private long messagetime = -1L;
    private MobSettings settings;

    public void initialize(ServerLevel level, ChunkCoord cc, MobSettings settings) {
        Random random = new Random(level.m_7328_() * 899812591L + (long)cc.chunkX() * 916023653L + (long)cc.chunkZ() * 797003437L);
        random.nextFloat();
        random.nextFloat();
        this.haunted = (double)random.nextFloat() < settings.getHauntedChance();
        MobSettings.Range<Integer> amounts = settings.getMobAmounts();
        this.totalMobs = random.nextInt(amounts.min(), amounts.max());
        this.settings = settings;
    }

    @Nullable
    public MobSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MobSettings settings) {
        this.settings = settings;
    }

    public boolean isHaunted() {
        return this.haunted;
    }

    public int getTotalMobs() {
        return this.totalMobs;
    }

    public int getNumberKilled() {
        return this.numberKilled;
    }

    public void setNumberKilled(int numberKilled) {
        this.numberKilled = numberKilled;
    }

    public int getEnteredCount() {
        return this.enteredCount;
    }

    public void newKill() {
        ++this.numberKilled;
    }

    public void enterBuilding() {
        ++this.enteredCount;
    }

    public void setMessagetime(long messagetime) {
        this.messagetime = messagetime;
    }

    public long getMessagetime() {
        return this.messagetime;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.haunted = nbt.m_128471_("haunted");
        this.totalMobs = nbt.m_128451_("max");
        this.numberKilled = nbt.m_128451_("killed");
        this.enteredCount = nbt.m_128451_("enteredCount");
        this.messagetime = nbt.m_128441_("messagetime") ? nbt.m_128454_("messagetime") : -1L;
    }

    public void writeToNBT(CompoundTag compound) {
        compound.m_128379_("haunted", this.haunted);
        compound.m_128405_("max", this.totalMobs);
        compound.m_128405_("killed", this.numberKilled);
        compound.m_128405_("enteredCount", this.enteredCount);
        compound.m_128356_("messagetime", this.messagetime);
    }
}

