/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.lostsouls.LostSouls;
import mcjty.lostsouls.commands.ModCommands;
import mcjty.lostsouls.data.LostChunkData;
import mcjty.lostsouls.data.LostSoulData;
import mcjty.lostsouls.data.MobSettings;
import mcjty.lostsouls.setup.Config;
import mcjty.lostsouls.setup.ModSetup;
import mcjty.lostsouls.varia.ChunkCoord;
import mcjty.lostsouls.varia.Tools;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;

public class ForgeEventHandlers {
    public static int timeout = -1;
    private Map<UUID, ChunkCoord> playerChunks = new HashMap<UUID, ChunkCoord>();
    private static final Component DEFAULT_NAME = Component.m_237113_((String)"@");
    private static final CommandSource EMPTY = new CommandSource(){

        public void m_213846_(Component component) {
        }

        public boolean m_6999_() {
            return false;
        }

        public boolean m_7028_() {
            return false;
        }

        public boolean m_6102_() {
            return false;
        }
    };

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ILostCityInformation info;
        Level world = event.getLevel();
        if (((Boolean)Config.LOCK_CHESTS_UNTIL_CLEARED.get()).booleanValue() && !world.f_46443_ && (info = ModSetup.lostCities.getLostInfo(world)) != null) {
            ILostChunkInfo chunkInfo;
            String buildingType;
            int chunkZ;
            int chunkX;
            LostChunkData data;
            BlockPos pos = event.getPos();
            BlockEntity te = world.m_7702_(pos);
            if ((((Boolean)Config.LOCK_ONLY_CHESTS.get()).booleanValue() && te instanceof RandomizableContainerBlockEntity || !((Boolean)Config.LOCK_ONLY_CHESTS.get()).booleanValue() && te != null) && this.isHaunted(data = LostSoulData.getSoulData(world, chunkX = pos.m_123341_() >> 4, chunkZ = pos.m_123343_() >> 4, info), buildingType = (chunkInfo = info.getChunkInfo(chunkX, chunkZ)).getBuildingType())) {
                event.setCanceled(true);
                if (((Boolean)Config.ANNOUNCE_CHESTLOCKED.get()).booleanValue()) {
                    MutableComponent unsafeMessage = Component.m_237115_((String)((String)Config.MESSAGE_UNSAFE_BUILDING.get()));
                    event.getEntity().m_213846_((Component)unsafeMessage);
                }
            }
        }
    }

    @SubscribeEvent
    public void onTickEvent(TickEvent.ServerTickEvent event) {
        if (--timeout > 0) {
            return;
        }
        timeout = (Integer)Config.SERVERTICK_TIMEOUT.get();
        PlayerList list = ServerLifecycleHooks.getCurrentServer().m_6846_();
        for (ServerPlayer player : list.m_11314_()) {
            ILostCityInformation info;
            UUID uuid = player.m_20148_();
            BlockPos position = player.m_20183_();
            int chunkX = position.m_123341_() >> 4;
            int chunkZ = position.m_123343_() >> 4;
            ChunkCoord chunkCoord = new ChunkCoord((ResourceKey<Level>)player.m_9236_().m_46472_(), chunkX, chunkZ);
            boolean entered = false;
            if (!this.playerChunks.containsKey(uuid)) {
                this.playerChunks.put(uuid, chunkCoord);
                entered = true;
            } else {
                ChunkCoord oldPos = this.playerChunks.get(uuid);
                if (!oldPos.equals(chunkCoord)) {
                    this.playerChunks.put(uuid, chunkCoord);
                    entered = true;
                }
            }
            if ((info = ModSetup.lostCities.getLostInfo(player.m_9236_())) == null) continue;
            this.handleSpawn(player, info, entered);
        }
    }

    private boolean isHaunted(LostChunkData data, String buildingType) {
        if (buildingType == null) {
            return false;
        }
        if (Config.getExcludedBuildings().contains(buildingType)) {
            return false;
        }
        return data.isHaunted() && data.getNumberKilled() < data.getTotalMobs();
    }

    private void handleSpawn(ServerPlayer player, ILostCityInformation lost, boolean entered) {
        int chunkZ;
        BlockPos position = player.m_20183_();
        int chunkX = position.m_123341_() >> 4;
        ILostChunkInfo chunkInfo = lost.getChunkInfo(chunkX, chunkZ = position.m_123343_() >> 4);
        String buildingType = chunkInfo.getBuildingType();
        if (buildingType != null) {
            ServerLevel world = (ServerLevel)player.m_9236_();
            RandomSource rand = world.m_213780_();
            long gameTime = world.m_46467_();
            LostChunkData data = LostSoulData.getSoulData((Level)world, chunkX, chunkZ, lost);
            if (this.isHaunted(data, buildingType)) {
                double distance;
                double z;
                double y;
                double x;
                int realHeight = lost.getRealHeight(chunkInfo.getCityLevel());
                int miny = realHeight - (chunkInfo.getNumCellars() + 1) * 6;
                int maxy = realHeight + (chunkInfo.getNumFloors() + 1) * 6;
                if (position.m_123342_() < miny || position.m_123342_() > maxy) {
                    return;
                }
                LostSoulData ld = LostSoulData.getData((Level)world);
                MobSettings settings = data.getSettings();
                if (settings == null) {
                    settings = ld.getSettingsForChunk(world, new ChunkCoord((ResourceKey<Level>)world.m_46472_(), chunkX, chunkZ), lost);
                    data.setSettings(settings);
                }
                if (entered) {
                    data.enterBuilding();
                    ld.m_77762_();
                    this.enterBuilding(player, data, gameTime, world);
                }
                ILostChunkInfo.MultiBuildingInfo mb = chunkInfo.getMultiBuildingInfo();
                int rootX = chunkX;
                int rootZ = chunkZ;
                int maxChunkX = chunkX;
                int maxChunkZ = chunkZ;
                if (mb != null) {
                    rootX = chunkX - mb.offsetX();
                    rootZ = chunkZ - mb.offsetZ();
                    chunkX = rootX + rand.m_216339_(0, mb.w());
                    chunkZ = rootZ + rand.m_216339_(0, mb.h());
                    maxChunkX = rootX + mb.w();
                    maxChunkZ = rootZ + mb.h();
                }
                if (world.m_8055_(new BlockPos((int)(x = (double)(chunkX * 16) + Math.floor(rand.m_188500_() * 16.0) + 0.5), (int)((y = (double)(position.m_123342_() + rand.m_188503_(3) - 1)) - 1.0), (int)(z = (double)(chunkZ * 16) + Math.floor(rand.m_188500_() * 16.0) + 0.5))).m_60795_()) {
                    y -= 1.0;
                }
                if (!world.m_8055_(new BlockPos((int)x, (int)y, (int)z)).m_60795_()) {
                    y += 1.0;
                }
                boolean allowSpawn = true;
                if (((Boolean)Config.SPAWN_ON_BLOCK.get()).booleanValue()) {
                    boolean bl = allowSpawn = !world.m_8055_(new BlockPos((int)x, (int)(y - 1.0), (int)z)).m_60795_();
                }
                if (allowSpawn && world.m_8055_(new BlockPos((int)x, (int)y, (int)z)).m_60795_() && (distance = Math.sqrt(position.m_203198_((double)((int)x), (double)((int)y), (double)((int)z)))) >= (Double)Config.MIN_SPAWN_DISTANCE.get() && distance <= (Double)Config.MAX_SPAWN_DISTANCE.get()) {
                    int totalMobsToSpawn = data.getTotalMobs() - data.getNumberKilled();
                    this.spawnMob(rand, settings, world, x, y, z, rootX, rootZ, maxChunkX, maxChunkZ, miny, maxy, totalMobsToSpawn);
                }
            }
        }
    }

    private void spawnMob(RandomSource rand, MobSettings settings, ServerLevel world, double x, double y, double z, int chunkX, int chunkZ, int maxChunkX, int maxChunkZ, int minY, int maxY, int totalMobs) {
        ResourceLocation mob = Tools.getRandomFromList(rand, settings.getMobs());
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mob);
        if (type == null) {
            throw new RuntimeException("Unknown entity '" + String.valueOf(mob) + "'!");
        }
        int cnt = 0;
        int maxEntities = 0;
        if (((Boolean)Config.USE_CHUNK_CHECK.get()).booleanValue()) {
            maxEntities = totalMobs;
            List entityList = world.m_6249_((Entity)null, new AABB((double)(chunkX * 16), (double)minY, (double)(chunkZ * 16), (double)((maxChunkX + 1) * 16), (double)maxY, (double)((maxChunkZ + 1) * 16)), entity -> entity.m_19880_().stream().anyMatch(tag -> tag.contains("_ls_/")));
            cnt = entityList.size();
        } else {
            maxEntities = (Integer)Config.SPAWN_MAX_NEARBY.get();
            cnt = world.m_6249_((Entity)null, new AABB(x, y, z, x + 1.0, y + 1.0, z + 1.0).m_82400_((double)((Integer)Config.SPAWN_MAX_NEARBY_RADIUS.get()).intValue()), entity -> entity.m_19880_().stream().anyMatch(tag -> tag.contains("_ls_/"))).size();
        }
        if (cnt <= maxEntities) {
            Entity entity2 = type.m_20615_((Level)world);
            entity2.m_6034_(x, y, z);
            entity2.m_146926_(rand.m_188501_() * 360.0f);
            if (entity2 instanceof Mob) {
                Mob mobEntity = (Mob)entity2;
                if (!((Boolean)Config.CHECK_VALID_SPAWN.get()).booleanValue() || mobEntity.m_6914_((LevelReader)world)) {
                    this.boostEntity(settings, (Level)world, (LivingEntity)entity2);
                    entity2.m_20049_("_ls_/" + String.valueOf(world.m_46472_().m_135782_()) + "/" + chunkX + "/" + chunkZ);
                    mobEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(mobEntity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    world.m_7967_(entity2);
                }
            }
        }
    }

    private void enterBuilding(ServerPlayer player, LostChunkData data, long gameTime, ServerLevel world) {
        int enteredCount = data.getEnteredCount();
        if (((Boolean)Config.ANNOUNCE_ENTER.get()).booleanValue()) {
            long lastMessagetime = data.getMessagetime();
            if (enteredCount == 1) {
                MutableComponent firstMessage = Component.m_237115_((String)((String)Config.MESSAGE_BUILDING_HAUNTED.get()));
                player.m_213846_((Component)firstMessage);
            } else if (lastMessagetime + (Long)Config.MESSAGE_INTERVAL.get() < gameTime) {
                String msg = (String)Config.MESSAGE_BUILDING_HAUNTED_REPEAT.get();
                if ("<same>".equals(msg)) {
                    msg = (String)Config.MESSAGE_BUILDING_HAUNTED.get();
                }
                MutableComponent message = Component.m_237115_((String)msg);
                player.m_213846_((Component)message);
            }
            data.setMessagetime(gameTime);
        }
        if (enteredCount == 1) {
            this.executeCommands(player, (Level)world, (List)Config.COMMAND_FIRSTTIME.get());
        }
        if (enteredCount >= 1) {
            this.executeCommands(player, (Level)world, (List)Config.COMMAND_ENTERED.get());
        }
    }

    private void executeCommands(ServerPlayer player, Level world, List<? extends String> commands) {
        if (!commands.isEmpty()) {
            BlockPos pos = player.m_20183_();
            ServerLevel level = (ServerLevel)world;
            CommandSourceStack stack = new CommandSourceStack(EMPTY, Vec3.m_82512_((Vec3i)pos), Vec2.f_82462_, level, 2, DEFAULT_NAME.getString(), DEFAULT_NAME, level.m_7654_(), (Entity)player);
            for (String string : commands) {
                level.m_7654_().m_129892_().m_230957_(stack, string);
            }
        }
    }

    private void boostEntity(MobSettings settings, Level world, LivingEntity entity) {
        Item item;
        ResourceLocation boots;
        Item item2;
        ResourceLocation leggings;
        Item item3;
        ResourceLocation chestplate;
        Item item4;
        ResourceLocation helmet;
        Item item5;
        double newMax;
        double f;
        AttributeInstance entityAttribute = entity.m_21051_(Attributes.f_22276_);
        RandomSource rand = world.m_213780_();
        if (entityAttribute != null) {
            f = (double)rand.m_188501_() * ((Double)Config.MAX_HEALTH_BONUS.get() - (Double)Config.MIN_HEALTH_BONUS.get()) + (Double)Config.MIN_HEALTH_BONUS.get();
            newMax = entityAttribute.m_22115_() * f;
            entityAttribute.m_22100_(newMax);
            entity.m_21153_((float)newMax);
        }
        if ((entityAttribute = entity.m_21051_(Attributes.f_22281_)) != null) {
            f = (double)rand.m_188501_() * ((Double)Config.MAX_DAMAGE_BONUS.get() - (Double)Config.MIN_DAMAGE_BONUS.get()) + (Double)Config.MIN_DAMAGE_BONUS.get();
            newMax = entityAttribute.m_22115_() * f;
            entityAttribute.m_22100_(newMax);
        }
        for (MobSettings.Effect pair : settings.getEffects()) {
            if (!(rand.m_188501_() < pair.weight())) continue;
            ResourceLocation effect = pair.name();
            MobEffect value = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effect);
            if (value == null) {
                throw new RuntimeException("Cannot find potion effect '" + String.valueOf(effect) + "'!");
            }
            int amplitude = pair.level();
            entity.m_7292_(new MobEffectInstance(value, 1000000, amplitude));
        }
        ResourceLocation weapon = Tools.getRandomFromList(rand, settings.getWeapons());
        if (weapon != null && (item5 = (Item)ForgeRegistries.ITEMS.getValue(weapon)) != null) {
            entity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)item5));
        }
        if ((helmet = Tools.getRandomFromList(rand, settings.getHelmets())) != null && (item4 = (Item)ForgeRegistries.ITEMS.getValue(helmet)) != null) {
            entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)item4));
        }
        if ((chestplate = Tools.getRandomFromList(rand, settings.getChestplates())) != null && (item3 = (Item)ForgeRegistries.ITEMS.getValue(chestplate)) != null) {
            entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)item3));
        }
        if ((leggings = Tools.getRandomFromList(rand, settings.getLeggings())) != null && (item2 = (Item)ForgeRegistries.ITEMS.getValue(leggings)) != null) {
            entity.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)item2));
        }
        if ((boots = Tools.getRandomFromList(rand, settings.getBoots())) != null && (item = (Item)ForgeRegistries.ITEMS.getValue(boots)) != null) {
            entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)item));
        }
    }

    @SubscribeEvent
    public void onKill(LivingDeathEvent event) {
        Entity source = event.getSource().m_7639_();
        if (source instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)source;
            for (String tag : event.getEntity().m_19880_()) {
                if (!tag.startsWith("_ls_/")) continue;
                String[] split = StringUtils.split((String)tag, (char)'/');
                try {
                    int x = Integer.parseInt(split[split.length - 2]);
                    int z = Integer.parseInt(split[split.length - 1]);
                    ILostCityInformation info = ModSetup.lostCities.getLostInfo(player.m_9236_());
                    LostChunkData data = LostSoulData.getSoulData(event.getEntity().m_9236_(), x, z, info);
                    MobSettings settings = data.getSettings();
                    if (settings != null) {
                        LostSoulData ld = LostSoulData.getData(event.getEntity().m_9236_());
                        settings = ld.getSettingsForChunk((ServerLevel)event.getEntity().m_9236_(), new ChunkCoord((ResourceKey<Level>)event.getEntity().m_9236_().m_46472_(), x, z), info);
                        data.setSettings(settings);
                    }
                    data.newKill();
                    if (((Boolean)Config.ANNOUNCE_CLEARED.get()).booleanValue()) {
                        if (data.getNumberKilled() == data.getTotalMobs()) {
                            MutableComponent clearMessage = Component.m_237115_((String)((String)Config.MESSAGE_BUILDING_CLEARED.get()));
                            player.m_213846_((Component)clearMessage);
                            this.executeCommands(player, source.m_20193_(), (List)Config.COMMAND_CLEARED.get());
                        } else if (data.getNumberKilled() == data.getTotalMobs() / 2) {
                            MutableComponent halfwayMessage = Component.m_237115_((String)((String)Config.MESSAGE_BUILDING_HALFWAY.get()));
                            player.m_213846_((Component)halfwayMessage);
                        }
                    }
                    LostSoulData.getData(event.getEntity().m_9236_()).m_77762_();
                }
                catch (NumberFormatException e) {
                    LostSouls.logger.error("ForgeEventHandlers.onKill ERROR", (Throwable)e);
                }
                return;
            }
        }
    }
}

