/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.slot.type;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.item.inventory.IInventorySlot;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.ISlotNotify;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotTemplate;
import java.lang.reflect.Field;
import java.util.function.BiFunction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;

public class SlotGeneric
extends SlotItemHandler
implements IInventorySlot {
    private final SlotTemplate _template;
    private final SlotFactory _factory;
    private static final Field s_xPosField = SlotGeneric.getPosField("f_40220_");
    private static final Field s_yPosField = SlotGeneric.getPosField("f_40221_");

    public SlotGeneric(IItemHandler itemHandler, SlotFactory slotFactory) {
        super(itemHandler, slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY());
        this._template = slotFactory.getTemplate();
        this._factory = slotFactory;
    }

    public SlotTemplate getTemplate() {
        return this._template;
    }

    public SlotFactory getFactory() {
        return this._factory;
    }

    public void translate(BiFunction<Integer, Integer, Point> mapper) {
        SlotGeneric.setPos(this, mapper.apply(this.getFactory().getX(), this.getFactory().getY()));
    }

    public boolean m_5857_(ItemStack stack) {
        return this.getTemplate().match(this.getSlotIndex(), stack);
    }

    public void m_5852_(ItemStack stack) {
        IItemHandler itemHandler = this.getItemHandler();
        if (itemHandler instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)itemHandler).setStackInSlot(this.getSlotIndex(), stack);
            this.m_6654_();
            if (itemHandler instanceof ISlotNotify) {
                ((ISlotNotify)itemHandler).onSlotChanged(itemHandler, this.getSlotIndex(), stack);
            }
        }
    }

    @Override
    public int getIndex() {
        return this.getSlotIndex();
    }

    @Override
    public ItemStack getStackInSlot() {
        return this.m_7993_();
    }

    @Override
    public void setStackInSlot(ItemStack stack) {
        this.m_5852_(stack);
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        ItemStack remainder = this.getItemHandler().insertItem(this.getIndex(), stack, true);
        return remainder.m_41619_() || remainder.m_41613_() < stack.m_41613_();
    }

    @Override
    public boolean canExtractStack(int amount) {
        ItemStack remainder = this.getItemHandler().extractItem(this.getIndex(), amount, true);
        return !remainder.m_41619_() && amount == remainder.m_41613_();
    }

    @Override
    public int getSlotLimit(ItemStack stack) {
        return stack.m_41619_() ? this.m_6641_() : Math.min(this.m_6641_(), stack.m_41741_());
    }

    private static void setPos(SlotGeneric slot, Point pos) {
        try {
            s_xPosField.setInt(slot, pos.X);
        }
        catch (IllegalAccessException e) {
            Log.LOGGER.warn(Log.CORE, "Unable to set field xPos for a SlotGeneric");
        }
        try {
            s_yPosField.setInt(slot, pos.Y);
        }
        catch (IllegalAccessException e) {
            Log.LOGGER.warn(Log.CORE, "Unable to set field yPos for a SlotGeneric");
        }
    }

    @Nullable
    private static Field getPosField(String name) {
        try {
            return ObfuscationReflectionHelper.findField(Slot.class, (String)name);
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException ex) {
            Log.LOGGER.error(Log.CORE, "SlotGeneric - Unable to get field {} : {}", (Object)name, (Object)ex);
            return null;
        }
    }
}

