/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item;

import com.google.common.base.Preconditions;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TintedBucketItem
extends BucketItem {
    private final BiFunction<@NotNull ItemStack, Integer, Integer> _colorProvider;

    public TintedBucketItem(Fluid fluid, Item.Properties properties) {
        this(fluid, properties, (stack, tintIndex) -> 1 == tintIndex ? 0xFF000000 | IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor() : -1);
    }

    public TintedBucketItem(Fluid fluid, Item.Properties properties, BiFunction<@NotNull ItemStack, Integer, Integer> colorProvider) {
        super(fluid, properties);
        Preconditions.checkNotNull(colorProvider, (Object)"Color provider must not be null");
        this._colorProvider = colorProvider;
    }

    public static int getTintColour(ItemStack stack, int tintIndex) {
        Item item = stack.m_41720_();
        if (item instanceof TintedBucketItem) {
            TintedBucketItem bucket = (TintedBucketItem)item;
            return bucket._colorProvider.apply(stack, tintIndex);
        }
        return -1;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidBucketWrapper(stack);
    }
}

