/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.fluid;

import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.AbstractStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.data.stack.StackAdapters;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import java.util.function.BiPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

public class FluidStackHolder
extends AbstractStackHolder<FluidStackHolder, FluidStack>
implements IStackHolderAccess<FluidStackHolder, FluidStack>,
IFluidHandler,
INBTSerializable<CompoundTag>,
ISyncableEntity,
IDebuggable {
    protected NonNullList<FluidStack> _stacks;

    public FluidStackHolder(int size) {
        this((NonNullList<FluidStack>)NonNullList.m_122780_((int)size, (Object)FluidStack.EMPTY));
    }

    public FluidStackHolder(int size, BiPredicate<Integer, FluidStack> stackValidator) {
        this((NonNullList<FluidStack>)NonNullList.m_122780_((int)size, (Object)FluidStack.EMPTY), stackValidator);
    }

    public FluidStackHolder(NonNullList<FluidStack> stacks) {
        this._stacks = stacks;
        this.setMaxCapacity(Integer.MAX_VALUE);
    }

    public FluidStackHolder(NonNullList<FluidStack> stacks, BiPredicate<Integer, FluidStack> stackValidator) {
        super(stackValidator);
        this._stacks = stacks;
        this.setMaxCapacity(Integer.MAX_VALUE);
    }

    public void setSize(int size) {
        this._stacks = NonNullList.m_122780_((int)size, (Object)FluidStack.EMPTY);
    }

    @Override
    public boolean isEmpty(int index) {
        return this.getFluidInTank(index).isEmpty();
    }

    @Override
    public int getAmount(int index) {
        return this.getFluidInTank(index).getAmount();
    }

    @Override
    public FluidStack getStackAt(int index) {
        return this.getFluidInTank(index);
    }

    @Override
    public void setStackAt(int index, FluidStack stack) {
        this.validateSlotIndex(index);
        this._stacks.set(index, (Object)stack);
    }

    public int getTanks() {
        return this._stacks.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        this.validateSlotIndex(tank);
        return (FluidStack)this._stacks.get(tank);
    }

    public int getTankCapacity(int tank) {
        this.validateSlotIndex(tank);
        return this.getMaxCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        this.validateSlotIndex(tank);
        return this.isStackValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        int tanks = this.getTanks();
        int filled = 0;
        int resourceAmount = resource.getAmount();
        for (int tank = 0; tank < tanks && resourceAmount > 0; ++tank) {
            FluidStack content;
            if (!this.isFluidValid(tank, resource) || !(content = this.getFluidInTank(tank)).isEmpty() && !content.isFluidEqual(resource)) continue;
            int use = Math.min(this.getFreeSpace(tank), resourceAmount);
            filled += use;
            resourceAmount -= use;
            if (use <= 0 || !action.execute()) continue;
            if (content.isEmpty()) {
                this._stacks.set(tank, (Object)FluidHelper.stackFrom(resource, use));
                this.onChange(IStackHolder.ChangeType.Added, tank);
                continue;
            }
            if (!content.isFluidEqual(resource)) continue;
            content.grow(use);
            this.onChange(IStackHolder.ChangeType.Grown, tank);
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int tanks = this.getTanks();
        int drained = 0;
        int maxDrainAmount = resource.getAmount();
        for (int tank = 0; tank < tanks && maxDrainAmount > 0; ++tank) {
            FluidStack content = this.getFluidInTank(tank);
            if (content.isEmpty() || !content.isFluidEqual(resource)) continue;
            int use = Math.min(content.getAmount(), maxDrainAmount);
            drained += use;
            maxDrainAmount -= use;
            if (!action.execute()) continue;
            if (use == content.getAmount()) {
                this._stacks.set(tank, (Object)FluidStack.EMPTY);
                this.onChange(IStackHolder.ChangeType.Removed, tank);
                continue;
            }
            content.shrink(use);
            this.onChange(IStackHolder.ChangeType.Shrunk, tank);
        }
        return FluidHelper.stackFrom(resource, drained);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain >= 0) {
            int tanks = this.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack content = this.getFluidInTank(tank);
                if (content.isEmpty()) continue;
                return this.drain(FluidHelper.stackFrom(content, maxDrain), action);
            }
        }
        return FluidStack.EMPTY;
    }

    public CompoundTag serializeNBT() {
        return this.syncDataTo(new CompoundTag(), ISyncableEntity.SyncReason.FullSync);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.syncDataFrom(nbt, ISyncableEntity.SyncReason.FullSync);
    }

    @Override
    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        this.syncFrom(data, StackAdapters.FLUIDSTACK, size -> {
            if (size > 0) {
                this.setSize(size);
            }
            return this._stacks;
        });
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        return this.syncTo(data, this._stacks, StackAdapters.FLUIDSTACK);
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        DebuggableHelper.getDebugMessagesFor(messages, this);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this._stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this._stacks.size() + ")");
        }
    }
}

