/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.layout;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.layout.AbstractLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ControlLayoutPosition;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;

public class VerticalLayoutEngine
extends AbstractLayoutEngine<VerticalLayoutEngine> {
    @Override
    public void layout(IControlContainer controlsContainer) {
        Rectangle parentBounds = controlsContainer.getBounds();
        int defaultHeight = this.computeDefaultValueForUndefinedDimension(controlsContainer, DesiredDimension.Height, parentBounds.Height);
        int spacing = this.getControlsSpacing();
        int horizontalMargin = this.getHorizontalMargin();
        int maxWidth = parentBounds.Width - 2 * horizontalMargin;
        ObjectArrayList positions = new ObjectArrayList(controlsContainer.getControlsCount());
        int availableSpace = parentBounds.Height - 2 * this.getVerticalMargin() - (controlsContainer.getControlsCount() - 1) * spacing;
        for (IControl control : controlsContainer) {
            int controlHeight = Math.min(availableSpace, this.getControlDesiredDimension(control, DesiredDimension.Height, defaultHeight));
            positions.add(this.computeLayoutPosition(control, horizontalMargin, 0, maxWidth, controlHeight));
            availableSpace -= controlHeight;
        }
        int top = switch (this.getVerticalAlignment()) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalAlignment.Top -> 0;
            case VerticalAlignment.Bottom -> availableSpace;
            case VerticalAlignment.Center -> availableSpace / 2;
        };
        for (ControlLayoutPosition position : positions) {
            position.layoutAtY(top);
            top += position.height() + spacing;
        }
    }
}

