/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.GuiHelper;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.IDragSource;
import it.zerono.mods.zerocore.lib.client.gui.IDraggable;
import it.zerono.mods.zerocore.lib.client.gui.IDropTarget;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.IWindowsManager;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Theme;
import it.zerono.mods.zerocore.lib.data.Flags;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Window<C extends ModContainer>
implements IWindow {
    public final IEvent<BiConsumer<IWindow, IControl>> Focus;
    private static final Pair<List<Component>, List<Object>> EMPTY_TOOLTIPS = Pair.of(Collections.emptyList(), Collections.emptyList());
    private final IWindowsManager<C> _manager;
    private final IControlContainer _topLevelContainer;
    private final Flags<WindowFlags> _flags;
    private IControl _mouseOver;
    private IControl _keyboardFocus;

    Window(IWindowsManager<C> manager, IControlContainer topLevelContainer, int x, int y, int width, int height, boolean modal) {
        this._manager = manager;
        this._topLevelContainer = topLevelContainer;
        this._flags = new Flags<WindowFlags>(WindowFlags.class);
        this._flags.set(WindowFlags.Modal, modal);
        this._mouseOver = null;
        this._keyboardFocus = null;
        this.Focus = new Event<BiConsumer<IWindow, IControl>>();
        this._topLevelContainer.setBounds(new Rectangle(x, y, width, height));
        this._flags.set(WindowFlags.ContentVisible, this._topLevelContainer.getVisible());
    }

    public IWindowsManager<C> getWindowsManager() {
        return this._manager;
    }

    public ModContainerScreen<C> getGuiScreen() {
        return this.getWindowsManager().getGuiScreen();
    }

    public Optional<IControl> getFocus() {
        return Optional.ofNullable(this._keyboardFocus);
    }

    public Optional<IControl> findControl(int x, int y) {
        return this.isVisible() ? this._topLevelContainer.findControl(x, y) : Optional.empty();
    }

    public void paintToolTips(GuiGraphics gfx) {
        if (null != this._mouseOver) {
            int mouseX = Mth.m_14107_((double)(GuiHelper.getMouse().m_91589_() / this.getGuiScreen().getGuiScaleFactor()));
            int mouseY = Mth.m_14107_((double)(GuiHelper.getMouse().m_91594_() / this.getGuiScreen().getGuiScaleFactor()));
            this._mouseOver.paintToolTips(gfx, mouseX, mouseY);
        }
    }

    @Override
    public void setFocus(@Nullable IControl newFocus) {
        this._manager.setFocus(this, newFocus);
    }

    @Override
    public void captureMouse(IControl target) {
        this._manager.captureMouse(this, target);
    }

    @Override
    public void releaseMouse() {
        this._manager.releaseMouse();
    }

    @Override
    public boolean isMouseCaptured() {
        return this._manager.isMouseCaptured();
    }

    @Override
    public void startDragging(@NotNull IDraggable draggable, IDragSource source) {
        this._manager.startDragging(draggable, source);
    }

    @Override
    public boolean isDragging() {
        return this._manager.isDragging();
    }

    @Override
    public void hide() {
        this._flags.add(WindowFlags.Hidden);
    }

    @Override
    public void show() {
        this._flags.remove(WindowFlags.Hidden);
    }

    @Override
    public boolean isVisible() {
        return !this._flags.contains(WindowFlags.Hidden) && this._flags.contains(WindowFlags.ContentVisible);
    }

    @Override
    public float getPaintPartialTicks() {
        return this._manager.getPaintPartialTicks();
    }

    @Override
    public void onThemeChanged(Theme newTheme) {
        this._topLevelContainer.onThemeChanged(newTheme);
    }

    void onTick() {
        this._flags.set(WindowFlags.ContentVisible, this._topLevelContainer.getVisible());
        ModContainerScreen<C> gui = this.getGuiScreen();
        int mouseX = Mth.m_14107_((double)(GuiHelper.getMouse().m_91589_() / gui.getGuiScaleFactor()));
        int mouseY = Mth.m_14107_((double)(GuiHelper.getMouse().m_91594_() / gui.getGuiScaleFactor()));
        this.updateMouseOverControl(mouseX, mouseY);
    }

    void onWindowClosed() {
        this._topLevelContainer.onWindowClosed();
        this.Focus.unsubscribeAll();
    }

    void onFocusChanged(@Nullable IControl newFocus) {
        this.Focus.raise(c -> c.accept(this, newFocus));
    }

    void onPaintBackground(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        if (this.isVisible()) {
            this._topLevelContainer.onPaintBackground(gfx, partialTicks, mouseX, mouseY);
        }
    }

    void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        if (this.isVisible()) {
            this._topLevelContainer.onPaint(gfx, partialTicks, mouseX, mouseY);
        }
    }

    void onPaintOverlay(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        if (this.isVisible()) {
            this._topLevelContainer.onPaintOverlay(gfx, partialTicks, mouseX, mouseY);
        }
    }

    void onPaintDebugFrame(GuiGraphics gfx, Colour colour) {
        if (null != this._mouseOver) {
            this._mouseOver.onPaintDebugFrame(gfx, colour);
        }
    }

    void onDisplayDebugFrameControlName() {
        if (null != this._mouseOver) {
            CodeHelper.reportErrorToPlayer((Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_), null, new Component[]{Component.m_237113_((String)this._mouseOver.getName())});
        }
    }

    boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isVisible() && this._topLevelContainer.hitTest(mouseX, mouseY)) {
            return this._topLevelContainer.onMouseClicked(this, mouseX, mouseY, mouseButton);
        }
        return false;
    }

    boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        return this.isVisible() && this._topLevelContainer.onMouseReleased(this, mouseX, mouseY, mouseButton);
    }

    void onMouseMoved(int mouseX, int mouseY) {
        if (this.isVisible()) {
            this._topLevelContainer.onMouseMoved(this, mouseX, mouseY);
        }
    }

    boolean onMouseWheel(int mouseX, int mouseY, double movement) {
        return this.isVisible() && this._topLevelContainer.onMouseWheel(this, mouseX, mouseY, movement);
    }

    boolean onCharTyped(char typedChar, int keyCode) {
        return null != this._keyboardFocus && this._keyboardFocus.onCharTyped(this, typedChar, keyCode);
    }

    boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return null != this._keyboardFocus && this._keyboardFocus.onKeyPressed(this, keyCode, scanCode, modifiers);
    }

    boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return null != this._keyboardFocus && this._keyboardFocus.onKeyReleased(this, keyCode, scanCode, modifiers);
    }

    void validate(Consumer<Component> errorReport) {
        this._topLevelContainer.validate(errorReport);
    }

    private void updateMouseOverControl(int clippedX, int clippedY) {
        IControl newOver = this._topLevelContainer.findControl(clippedX, clippedY).orElse(null);
        if (this._mouseOver != newOver) {
            if (null != this._mouseOver) {
                this._mouseOver.setMouseOver(false, -1, -1);
            }
            if (this.isDragging() && !(newOver instanceof IDropTarget)) {
                return;
            }
            this._mouseOver = newOver;
            if (null != this._mouseOver) {
                this._mouseOver.setMouseOver(true, clippedX, clippedY);
            }
        }
    }

    private static enum WindowFlags {
        ContentVisible,
        Modal,
        Hidden,
        Focused;

    }
}

