/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block.multiblock;

import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class MultiblockPartTypeProperties<Controller extends IMultiblockController<Controller>, PartType extends IMultiblockPartType> {
    private final NonNullSupplier<NonNullSupplier<BlockEntityType<?>>> _tileTypeSupplier;
    private final NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock<Controller, PartType>> _blockFactory;
    private final NonNullFunction<BlockBehaviour.Properties, BlockBehaviour.Properties> _blockPropertiesFixer;
    private final NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock.MultiblockPartProperties<PartType>> _extendedPropertiesFixer;
    private final String _translationKey;

    public MultiblockPartTypeProperties(NonNullSupplier<NonNullSupplier<BlockEntityType<?>>> tileTypeSupplier, NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock<Controller, PartType>> blockFactory, String translationKey, NonNullFunction<BlockBehaviour.Properties, BlockBehaviour.Properties> blockPropertiesFixer) {
        this(tileTypeSupplier, blockFactory, translationKey, blockPropertiesFixer, ep -> ep);
    }

    public MultiblockPartTypeProperties(NonNullSupplier<NonNullSupplier<BlockEntityType<?>>> tileTypeSupplier, NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock<Controller, PartType>> blockFactory, String translationKey, NonNullFunction<BlockBehaviour.Properties, BlockBehaviour.Properties> blockPropertiesFixer, NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock.MultiblockPartProperties<PartType>> partPropertiesFixer) {
        this._tileTypeSupplier = tileTypeSupplier;
        this._blockFactory = blockFactory;
        this._translationKey = translationKey;
        this._blockPropertiesFixer = blockPropertiesFixer;
        this._extendedPropertiesFixer = partPropertiesFixer;
    }

    public MultiblockPartBlock<Controller, PartType> createBlock(PartType type) {
        return (MultiblockPartBlock)this._blockFactory.apply((Object)((MultiblockPartBlock.MultiblockPartProperties)this._extendedPropertiesFixer.apply(MultiblockPartBlock.MultiblockPartProperties.create(type, (BlockBehaviour.Properties)this._blockPropertiesFixer.apply((Object)IMultiblockPart.getDefaultBlockProperties())))));
    }

    public MultiblockPartBlock<Controller, PartType> createBlock(PartType type, IMultiblockVariant variant) {
        return (MultiblockPartBlock)this._blockFactory.apply((Object)((MultiblockPartBlock.MultiblockPartProperties)this._extendedPropertiesFixer.apply(MultiblockPartBlock.MultiblockPartProperties.create(type, (BlockBehaviour.Properties)this._blockPropertiesFixer.apply((Object)variant.getDefaultBlockProperties())).variant(variant))));
    }

    @Nullable
    public BlockEntity createTileEntity(BlockState state, BlockPos position) {
        return ((BlockEntityType)((NonNullSupplier)this._tileTypeSupplier.get()).get()).m_155264_(position, state);
    }

    public String getTranslationKey() {
        return this._translationKey;
    }
}

