/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control;

import com.google.common.base.Strings;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.AbstractVerticalIconSingleValueGaugeBar;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.WideAmountData;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class EnergyBar
extends AbstractVerticalIconSingleValueGaugeBar {
    private final EnergySystem _system;

    public EnergyBar(ModContainerScreen<? extends ModContainer> gui, String name, EnergySystem system, WideAmount maxValue, WideAmountData bindableValue, @Nullable String optionalTooltipLine) {
        super(gui, name, maxValue.doubleValue(), bindableValue.asDouble(), (NonNullSupplier<ISprite>)BaseIcons.PowerBar, (NonNullSupplier<ISprite>)BaseIcons.PowerBattery);
        this._system = system;
        BaseScreenToolTipsBuilder toolTips = new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.zerocore.base.control.energybar.line1").addTextAsValue(TextHelper.translatable("gui.zerocore.base.control.energybar.line2a"), new Component[]{TextHelper.translatable("gui.zerocore.base.control.energybar.line2b", CodeHelper.formatAsHumanReadableNumber(maxValue.doubleValue(), system.getUnit()))}).addTextAsValue(TextHelper.translatable("gui.zerocore.base.control.energybar.line3a"), new Component[]{TextHelper.translatable("gui.zerocore.base.control.energybar.line3b")}).addBindableObjectAsValue(bindableValue, this::getValueText).addBindableObjectAsValue(bindableValue, this::getPercentageText);
        if (!Strings.isNullOrEmpty((String)optionalTooltipLine)) {
            toolTips.addEmptyLine();
            toolTips.addTranslatable(optionalTooltipLine);
        }
        this.setTooltips(toolTips);
    }

    public void bindMaxValue(WideAmountData bindableValue) {
        bindableValue.bind(amount -> ((GaugeBar)this._bar).setMaxValue(amount.doubleValue()));
    }

    private MutableComponent getValueText(WideAmount amount) {
        return TextHelper.literal(CodeHelper.formatAsHumanReadableNumber(amount.doubleValue(), this._system.getUnit()));
    }

    private MutableComponent getPercentageText(WideAmount amount) {
        double percentage = amount.percentage(WideAmount.from(((GaugeBar)this._bar).getMaxValue()));
        return TextHelper.literal("%d", (int)(percentage * 100.0));
    }
}

