/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.mixin.lootr;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mod.cdv.util.CounterRecheckBlock;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.entities.LootrBarrelBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.util.ChestUtil;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RandomizableContainerBlockEntity.class})
public abstract class RandomizableContainerLootrMixin
extends BaseContainerBlockEntity
implements ILootBlockEntity,
CounterRecheckBlock {
    public Set<UUID> openers = new HashSet<UUID>();
    protected ResourceLocation savedLootTable = null;
    protected long seed = -1L;
    protected UUID tileId = null;
    @Shadow
    protected ResourceLocation f_59605_;
    private boolean savingToItem = false;
    boolean opened;
    final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level p_155460_, BlockPos p_155461_, BlockState p_155462_) {
        }

        protected void m_142289_(Level p_155473_, BlockPos p_155474_, BlockState p_155475_) {
        }

        protected void m_142148_(Level p_155463_, BlockPos p_155464_, BlockState p_155465_, int p_155466_, int p_155467_) {
        }

        protected boolean m_142718_(Player player) {
            ChestMenu menu;
            Container var4;
            AbstractContainerMenu var3 = player.f_36096_;
            if (var3 instanceof ChestMenu && (var4 = (menu = (ChestMenu)var3).m_39261_()) instanceof SpecialChestInventory) {
                SpecialChestInventory chest = (SpecialChestInventory)var4;
                return RandomizableContainerLootrMixin.this.getTileId().equals(chest.getTileId());
            }
            return false;
        }
    };

    protected RandomizableContainerLootrMixin(BlockEntityType<?> p_155076_, BlockPos p_155077_, BlockState p_155078_) {
        super(p_155076_, p_155077_, p_155078_);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof LootrBarrelBlockEntity) {
            LootrBarrelBlockEntity barrel = (LootrBarrelBlockEntity)blockentity;
            barrel.recheckOpen();
        }
    }

    public void unpackLootTable(Player player, Container inventory, ResourceLocation overrideTable, long l) {
        if (this.f_58857_ != null && this.savedLootTable != null && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_278653_().m_278676_(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.f_79105_) {
                Logger var10000 = LootrAPI.LOG;
                ResourceLocation var10001 = this.f_58857_.m_46472_().m_135782_();
                var10000.error("Unable to fill loot barrel in {} at {} as the loot table '{}' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.", (Object)var10001, (Object)this.f_58858_, (Object)(overrideTable != null ? overrideTable : this.savedLootTable));
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue()) {
                    player.m_5661_(ChestUtil.getInvalidTable((ResourceLocation)(overrideTable != null ? overrideTable : this.savedLootTable)), false);
                }
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, overrideTable != null ? overrideTable : this.f_59605_);
            }
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (player != null) {
                builder.m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player);
            }
            loottable.m_287188_(inventory, builder.m_287235_(LootContextParamSets.f_81411_), LootrAPI.getLootSeed((long)this.seed));
        }
    }

    @Inject(method={"setLootTable(Lnet/minecraft/resources/ResourceLocation;J)V"}, at={@At(value="HEAD")})
    private void setLootTable(ResourceLocation lootTableIn, long seedIn, CallbackInfo ci) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
    }

    @Shadow
    public abstract void m_59626_(ResourceLocation var1, long var2);

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("specialLootChest_table", 8)) {
            this.savedLootTable = ResourceLocation.parse((String)compound.m_128461_("specialLootChest_table"));
        }
        if (compound.m_128425_("specialLootChest_seed", 4)) {
            this.seed = compound.m_128454_("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.m_128425_("LootTable", 8)) {
            this.savedLootTable = ResourceLocation.parse((String)compound.m_128461_("LootTable"));
            if (compound.m_128425_("LootTableSeed", 4)) {
                this.seed = compound.m_128454_("LootTableSeed");
            }
            this.m_59626_(this.savedLootTable, this.seed);
        }
        if (compound.m_128403_("tileId")) {
            this.tileId = compound.m_128342_("tileId");
        }
        if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.m_128441_("LootrOpeners")) {
            ListTag openers = compound.m_128437_("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.m_129233_((Tag)item));
            }
        }
        this.requestModelDataUpdate();
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.savedLootTable != null) {
            compound.m_128359_("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.m_128356_("LootTableSeed", this.seed);
        }
        if (!LootrAPI.shouldDiscard() && !this.savingToItem) {
            compound.m_128362_("tileId", this.getTileId());
            ListTag list = new ListTag();
            for (UUID opener : this.openers) {
                list.add((Object)NbtUtils.m_129226_((UUID)opener));
            }
            compound.m_128365_("LootrOpeners", (Tag)list);
        }
    }

    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    public BlockPos getPosition() {
        return this.m_58899_();
    }

    public long getSeed() {
        return this.seed;
    }

    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public void updatePacketViaState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 8);
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag result = super.m_5995_();
        this.m_183515_(result);
        return result;
    }

    public void setOpened(boolean b) {
        this.opened = b;
    }

    public Set<UUID> getOpeners() {
        return this.openers;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    public void refreshCounter() {
        this.recheckOpen();
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }
}

