/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv;

import java.util.Objects;
import java.util.UUID;
import mod.cdv.AttributeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import noobanidus.mods.lootr.advancement.GenericTrigger;
import noobanidus.mods.lootr.api.IHasOpeners;
import noobanidus.mods.lootr.api.MenuBuilder;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.init.ModAdvancements;
import noobanidus.mods.lootr.init.ModStats;
import noobanidus.mods.lootr.util.ChestUtil;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="apoc_patches")
public final class Boot {
    public Boot(FMLJavaModLoadingContext context) {
        IEventBus iModBus = context.getModEventBus();
        AttributeRegistry.ATTRIBUTES.register(iModBus);
        iModBus.register((Object)this);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.config.getRight(), "apoc_patches.toml");
    }

    @SubscribeEvent
    public void modifyAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)AttributeRegistry.HEADSHOT_DATA.get(), 1.25);
    }

    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity tileEntity;
        Player plr = event.getEntity();
        BlockState state = plr.m_9236_().m_8055_(event.getPos());
        Level level = plr.m_9236_();
        if (plr instanceof ServerPlayer && state.m_60734_().m_7705_().contains("apocalypsenow") && (tileEntity = level.m_7702_(event.getPos())) instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity c = (RandomizableContainerBlockEntity)tileEntity;
            Boot.handleLootChest(state.m_60734_(), level, event.getPos(), plr);
            event.setCanceled(true);
        }
    }

    public static void handleLootChest(Block block, Level level, BlockPos pos, Player player) {
        if (!level.m_5776_() && !player.m_5833_()) {
            BlockEntity te = level.m_7702_(pos);
            if (te instanceof ILootBlockEntity) {
                int refreshValue;
                BaseContainerBlockEntity bce;
                ILootBlockEntity tile = (ILootBlockEntity)te;
                UUID tileId = tile.getTileId();
                if (tileId == null) {
                    player.m_5661_((Component)Component.m_237115_((String)"lootr.message.invalid_block").m_6270_(ChestUtil.getInvalidStyle()), true);
                    return;
                }
                if (te instanceof BaseContainerBlockEntity && !(bce = (BaseContainerBlockEntity)te).m_7525_(player)) {
                    return;
                }
                if (DataStorage.isDecayed((UUID)tileId)) {
                    level.m_46961_(pos, true);
                    Boot.notifyDecay(player, tileId);
                    return;
                }
                int decayValue = DataStorage.getDecayValue((UUID)tileId);
                if (decayValue > 0 && ConfigManager.shouldNotify((int)decayValue)) {
                    player.m_5661_((Component)Component.m_237110_((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).m_6270_(ChestUtil.getDecayStyle()), true);
                } else if (decayValue == -1 && ConfigManager.isDecaying((ServerLevel)((ServerLevel)level), (ILootBlockEntity)tile)) {
                    Boot.startDecay(player, tileId, decayValue);
                }
                GenericTrigger trigger = ModAdvancements.CHEST_PREDICATE;
                if (block instanceof BarrelBlock) {
                    trigger = ModAdvancements.BARREL_PREDICATE;
                } else if (block instanceof LootrShulkerBlock) {
                    trigger = ModAdvancements.SHULKER_PREDICATE;
                }
                trigger.trigger((ServerPlayer)player, (Object)tileId);
                if (DataStorage.isRefreshed((UUID)tileId)) {
                    DataStorage.refreshInventory((Level)level, (BlockPos)pos, (UUID)tileId, (ServerPlayer)((ServerPlayer)player));
                    Boot.notifyRefresh(player, tileId);
                }
                if ((refreshValue = DataStorage.getRefreshValue((UUID)tileId)) > 0 && ConfigManager.shouldNotify((int)refreshValue)) {
                    player.m_5661_((Component)Component.m_237110_((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).m_6270_(ChestUtil.getRefreshStyle()), true);
                } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)((ServerLevel)level), (ILootBlockEntity)tile)) {
                    Boot.startRefresh(player, tileId, refreshValue);
                }
                ServerPlayer var10003 = (ServerPlayer)player;
                final RandomizableContainerBlockEntity var10004 = (RandomizableContainerBlockEntity)te;
                Objects.requireNonNull(tile);
                SpecialChestInventory provider = DataStorage.getInventory((Level)level, (UUID)tileId, (BlockPos)pos, (ServerPlayer)var10003, (RandomizableContainerBlockEntity)var10004, (arg_0, arg_1, arg_2, arg_3) -> ((ILootBlockEntity)tile).unpackLootTable(arg_0, arg_1, arg_2, arg_3));
                if (provider == null) {
                    return;
                }
                provider.setMenuBuilder(new MenuBuilder(){

                    public AbstractContainerMenu build(int i, Inventory inventory, Container container, int i1) {
                        return var10004.m_7208_(i, inventory, inventory.f_35978_);
                    }
                });
                Boot.checkScore((ServerPlayer)player, tileId);
                if (Boot.addOpener((IHasOpeners)tile, player)) {
                    te.m_6596_();
                    tile.updatePacketViaState();
                }
                player.m_5893_((MenuProvider)provider);
                PiglinAi.m_34873_((Player)player, (boolean)true);
            }
        } else if (player.m_5833_()) {
            player.m_5893_(null);
        }
    }

    private static void checkScore(ServerPlayer player, UUID tileId) {
        if (!DataStorage.isScored((UUID)player.m_20148_(), (UUID)tileId)) {
            player.m_36246_(ModStats.LOOTED_STAT);
            ModAdvancements.SCORE_PREDICATE.trigger(player, null);
            DataStorage.score((UUID)player.m_20148_(), (UUID)tileId);
        }
    }

    private static boolean addOpener(IHasOpeners openable, Player player) {
        return openable.getOpeners().add(player.m_20148_());
    }

    private static void notifyDecay(Player player, UUID tileId) {
        player.m_5661_((Component)Component.m_237115_((String)"lootr.message.decayed").m_6270_(ChestUtil.getDecayStyle()), true);
        DataStorage.removeDecayed((UUID)tileId);
    }

    private static void notifyRefresh(Player player, UUID tileId) {
        DataStorage.removeRefreshed((UUID)tileId);
        player.m_5661_((Component)Component.m_237115_((String)"lootr.message.refreshed").m_6270_(ChestUtil.getRefreshStyle()), true);
    }

    private static void startDecay(Player player, UUID tileId, int decayValue) {
        DataStorage.setDecaying((UUID)tileId, (int)((Integer)ConfigManager.DECAY_VALUE.get()));
        player.m_5661_((Component)Component.m_237110_((String)"lootr.message.decay_start", (Object[])new Object[]{(Integer)ConfigManager.DECAY_VALUE.get() / 20}).m_6270_(ChestUtil.getDecayStyle()), true);
    }

    private static void startRefresh(Player player, UUID tileId, int refreshValue) {
        DataStorage.setRefreshing((UUID)tileId, (int)((Integer)ConfigManager.REFRESH_VALUE.get()));
        player.m_5661_((Component)Component.m_237110_((String)"lootr.message.refresh_start", (Object[])new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).m_6270_(ChestUtil.getRefreshStyle()), true);
    }

    public static class Config {
        public static final Pair<Config, ForgeConfigSpec> config = new ForgeConfigSpec.Builder().configure(Config::new);
        public static ForgeConfigSpec.ConfigValue<Boolean> allowHeadshots;

        public Config(ForgeConfigSpec.Builder builder) {
            allowHeadshots = builder.comment("Enable or disable headshots (Extra Feature)").define("allowHeadshots", false);
            builder.build();
        }
    }
}

