/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.potatoCannon;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.potatoCannon.PotatoCannonProjectileType;
import com.simibubi.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes;
import com.simibubi.create.content.equipment.potatoCannon.AllPotatoProjectileTypes;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.particle.AirParticleData;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotatoProjectileEntity
extends AbstractHurtingProjectile
implements IEntityAdditionalSpawnData {
    protected PotatoCannonProjectileType type;
    protected ItemStack stack = ItemStack.f_41583_;
    protected Entity stuckEntity;
    protected Vec3 stuckOffset;
    protected PotatoProjectileRenderMode stuckRenderer;
    protected double stuckFallSpeed;
    protected float additionalDamageMult = 1.0f;
    protected float additionalKnockback = 0.0f;
    protected float recoveryChance = 0.0f;

    public PotatoProjectileEntity(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public void setItem(ItemStack stack) {
        this.stack = stack;
        this.type = (PotatoCannonProjectileType)PotatoCannonProjectileType.getTypeForItem(this.m_9236_().m_9598_(), stack.m_41720_()).orElseGet(() -> this.m_9236_().m_9598_().m_175515_(CreateRegistries.POTATO_PROJECTILE_TYPE).m_246971_(AllPotatoProjectileTypes.FALLBACK)).m_203334_();
    }

    public void setEnchantmentEffectsFromCannon(ItemStack cannon) {
        int power = cannon.getEnchantmentLevel(Enchantments.f_44988_);
        int punch = cannon.getEnchantmentLevel(Enchantments.f_44989_);
        int flame = cannon.getEnchantmentLevel(Enchantments.f_44990_);
        int recovery = cannon.getEnchantmentLevel((Enchantment)AllEnchantments.POTATO_RECOVERY.get());
        if (power > 0) {
            this.additionalDamageMult = 1.0f + (float)power * 0.2f;
        }
        if (punch > 0) {
            this.additionalKnockback = (float)punch * 0.5f;
        }
        if (flame > 0) {
            this.m_20254_(100);
        }
        if (recovery > 0) {
            this.recoveryChance = 0.125f + (float)recovery * 0.125f;
        }
    }

    public ItemStack getItem() {
        return this.stack;
    }

    @Nullable
    public PotatoCannonProjectileType getProjectileType() {
        return this.type;
    }

    public void m_7378_(CompoundTag nbt) {
        this.setItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item")));
        this.additionalDamageMult = nbt.m_128457_("AdditionalDamage");
        this.additionalKnockback = nbt.m_128457_("AdditionalKnockback");
        this.recoveryChance = nbt.m_128457_("Recovery");
        super.m_7378_(nbt);
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("Item", (Tag)this.stack.serializeNBT());
        nbt.m_128350_("AdditionalDamage", this.additionalDamageMult);
        nbt.m_128350_("AdditionalKnockback", this.additionalKnockback);
        nbt.m_128350_("Recovery", this.recoveryChance);
        super.m_7380_(nbt);
    }

    @Nullable
    public Entity getStuckEntity() {
        if (this.stuckEntity == null) {
            return null;
        }
        if (!this.stuckEntity.m_6084_()) {
            return null;
        }
        return this.stuckEntity;
    }

    public void setStuckEntity(Entity stuckEntity) {
        this.stuckEntity = stuckEntity;
        this.stuckOffset = this.m_20182_().m_82546_(stuckEntity.m_20182_());
        this.stuckRenderer = new AllPotatoProjectileRenderModes.StuckToEntity(this.stuckOffset);
        this.stuckFallSpeed = 0.0;
        this.m_20256_(Vec3.f_82478_);
    }

    public PotatoProjectileRenderMode getRenderMode() {
        if (this.getStuckEntity() != null) {
            return this.stuckRenderer;
        }
        return this.type.renderMode();
    }

    public void m_8119_() {
        Entity stuckEntity = this.getStuckEntity();
        if (stuckEntity != null) {
            if (this.m_20186_() < stuckEntity.m_20186_() - 0.1) {
                this.pop(this.m_20182_());
                this.m_6074_();
            } else {
                this.stuckFallSpeed += 0.007 * (double)this.type.gravityMultiplier();
                this.stuckOffset = this.stuckOffset.m_82520_(0.0, -this.stuckFallSpeed, 0.0);
                Vec3 pos = stuckEntity.m_20182_().m_82549_(this.stuckOffset);
                this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            }
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05 * (double)this.type.gravityMultiplier(), 0.0).m_82490_((double)this.type.drag()));
        }
        super.m_8119_();
    }

    protected float m_6884_() {
        return 1.0f;
    }

    protected ParticleOptions m_5967_() {
        return new AirParticleData(1.0f, 10.0f);
    }

    protected boolean m_5931_() {
        return false;
    }

    protected void m_5790_(EntityHitResult ray) {
        Vec3 appliedMotion;
        boolean onServer;
        super.m_5790_(ray);
        if (this.getStuckEntity() != null) {
            return;
        }
        Vec3 hit = ray.m_82450_();
        Entity target = ray.m_82443_();
        float damage = (float)this.type.damage() * this.additionalDamageMult;
        float knockback = this.type.knockback() + this.additionalKnockback;
        Entity owner = this.m_19749_();
        if (!target.m_6084_()) {
            return;
        }
        if (owner instanceof LivingEntity) {
            ((LivingEntity)owner).m_21335_(target);
        }
        if (target instanceof PotatoProjectileEntity) {
            PotatoProjectileEntity ppe = (PotatoProjectileEntity)target;
            if (this.f_19797_ < 10 && target.f_19797_ < 10) {
                return;
            }
            if (ppe.getProjectileType() != this.getProjectileType()) {
                Entity entity;
                Player p;
                if (owner instanceof Player) {
                    p = (Player)owner;
                    AllAdvancements.POTATO_CANNON_COLLIDE.awardTo(p);
                }
                if ((entity = ppe.m_19749_()) instanceof Player) {
                    p = (Player)entity;
                    AllAdvancements.POTATO_CANNON_COLLIDE.awardTo(p);
                }
            }
        }
        this.pop(hit);
        if (target instanceof WitherBoss && ((WitherBoss)target).m_7090_()) {
            return;
        }
        if (this.type.preEntityHit(this.stack, ray)) {
            return;
        }
        boolean targetIsEnderman = target.m_6095_() == EntityType.f_20566_;
        int k = target.m_20094_();
        if (this.m_6060_() && !targetIsEnderman) {
            target.m_20254_(5);
        }
        boolean bl = onServer = !this.m_9236_().f_46443_;
        if (onServer && !target.m_6469_(this.causePotatoDamage(), damage)) {
            target.m_7311_(k);
            this.m_6074_();
            return;
        }
        if (targetIsEnderman) {
            return;
        }
        if (!this.type.onEntityHit(this.stack, ray) && onServer) {
            if (this.f_19796_.m_188500_() <= (double)this.recoveryChance) {
                this.recoverItem();
            } else {
                this.m_19983_(this.type.dropStack());
            }
        }
        if (!(target instanceof LivingEntity)) {
            PotatoProjectileEntity.playHitSound(this.m_9236_(), this.m_20182_());
            this.m_6074_();
            return;
        }
        LivingEntity livingentity = (LivingEntity)target;
        if (this.type.reloadTicks() < 10) {
            livingentity.f_19802_ = this.type.reloadTicks() + 10;
        }
        if (onServer && knockback > 0.0f && (appliedMotion = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockback * 0.6)).m_82556_() > 0.0) {
            livingentity.m_5997_(appliedMotion.f_82479_, 0.1, appliedMotion.f_82481_);
        }
        if (onServer && owner instanceof LivingEntity) {
            EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)owner);
            EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
        }
        if (livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer && !this.m_20067_()) {
            ((ServerPlayer)owner).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
        }
        if (onServer && owner instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)owner;
            if (!target.m_6084_() && target.m_6095_().m_20674_() == MobCategory.MONSTER || target instanceof Player && target != owner) {
                AllAdvancements.POTATO_CANNON.awardTo((Player)serverplayerentity);
            }
        }
        if (this.type.sticky() && target.m_6084_()) {
            this.setStuckEntity(target);
        } else {
            this.m_6074_();
        }
    }

    private void recoverItem() {
        if (!this.stack.m_41619_()) {
            this.m_19983_(ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)1));
        }
    }

    public static void playHitSound(Level world, Vec3 location) {
        AllSoundEvents.POTATO_HIT.playOnServer(world, (Vec3i)BlockPos.m_274446_((Position)location));
    }

    public static void playLaunchSound(Level world, Vec3 location, float pitch) {
        AllSoundEvents.FWOOMP.playAt(world, location, 1.0f, pitch, true);
    }

    protected void m_8060_(BlockHitResult ray) {
        Vec3 hit = ray.m_82450_();
        this.pop(hit);
        if (!this.type.onBlockHit((LevelAccessor)this.m_9236_(), this.stack, ray) && !this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188500_() <= (double)this.recoveryChance) {
                this.recoverItem();
            } else {
                this.m_19983_(this.getProjectileType().dropStack());
            }
        }
        super.m_8060_(ray);
        this.m_6074_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amt) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.pop(this.m_20182_());
        this.m_6074_();
        return true;
    }

    private void pop(Vec3 hit) {
        if (!this.stack.m_41619_()) {
            for (int i = 0; i < 7; ++i) {
                Vec3 m = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_19796_, (float)0.25f);
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.stack), hit.f_82479_, hit.f_82480_, hit.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
            }
        }
        if (!this.m_9236_().f_46443_) {
            PotatoProjectileEntity.playHitSound(this.m_9236_(), this.m_20182_());
        }
    }

    private DamageSource causePotatoDamage() {
        return CreateDamageSources.potatoCannon(this.m_9236_(), (Entity)this, this.m_19749_());
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.m_20699_(0.25f, 0.25f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        buffer.m_130079_(compound);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_7378_(additionalData.m_130260_());
    }
}

