/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.datagen.providers;

import com.tynoxs.buildersdelight.content.init.BdBlocks;
import com.tynoxs.buildersdelight.datagen.providers.BdTags;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class BdRecipes
extends RecipeProvider
implements IConditionBuilder {
    String[] woodTypes = new String[]{"acacia", "bamboo", "birch", "cherry", "crimson", "dark_oak", "jungle", "mangrove", "oak", "spruce", "warped"};
    String[] rockTypes = new String[]{"andesite", "granite", "diorite", "cobblestone", "stone_bricks"};

    public BdRecipes(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> pWriter) {
        this.registerFrameAndGlassRecipes(pWriter);
        this.registerStairsAndSlabRecipes(pWriter);
    }

    private void registerFrameAndGlassRecipes(Consumer<FinishedRecipe> pWriter) {
        HashSet<String> generatedIds = new HashSet<String>();
        for (String woodType : this.woodTypes) {
            for (int number = 1; number <= 8; ++number) {
                for (int plankNumber = 1; plankNumber <= 7; ++plankNumber) {
                    String frameName = woodType + "_frame_" + number;
                    String recipeId = String.valueOf(this.getRecipeId(frameName));
                    if (generatedIds.contains(recipeId)) continue;
                    this.generateFrameRecipe(pWriter, woodType, number, plankNumber);
                    this.generateGlassRecipe(pWriter, woodType, number, plankNumber);
                    generatedIds.add(recipeId);
                }
            }
        }
    }

    private void registerStairsAndSlabRecipes(Consumer<FinishedRecipe> pWriter) {
        HashSet<String> generatedIds = new HashSet<String>();
        for (String woodType : this.woodTypes) {
            for (int plankNumber = 1; plankNumber <= 7; ++plankNumber) {
                String plankName = woodType + "_planks_" + plankNumber;
                String recipeId = String.valueOf(this.getRecipeId(plankName));
                if (generatedIds.contains(recipeId)) continue;
                this.generateStairsRecipe(pWriter, woodType, plankNumber);
                this.generateSlabRecipe(pWriter, woodType, plankNumber);
                generatedIds.add(recipeId);
            }
        }
    }

    private void generateFrameRecipe(Consumer<FinishedRecipe> pWriter, String woodType, int number, int plankNumber) {
        String frameName = woodType + "_frame_" + number;
        String plankName = woodType + "_planks_" + plankNumber;
        TagKey<Item> woodPlanksTag = this.getWoodPlanksTag(woodType);
        BdBlocks.BLOCKS.getEntries().forEach(entry -> {
            Block block = (Block)entry.get();
            if (block.m_5456_().toString().equals(plankName)) {
                Item frameItem = (Item)BdBlocks.getBlockItemMap().get(frameName).get();
                if (block != Blocks.f_50016_ && frameItem != Items.f_41852_) {
                    ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)frameItem).m_126130_("202").m_126130_("010").m_126130_("202").m_206416_(Character.valueOf('0'), woodPlanksTag).m_206416_(Character.valueOf('1'), ItemTags.f_13167_).m_206416_(Character.valueOf('2'), Tags.Items.RODS_WOODEN).m_126132_("has_wool", (CriterionTriggerInstance)BdRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_13167_).m_45077_()})).m_126140_(pWriter, this.getRecipeId(frameName));
                }
            }
        });
    }

    private void generateStairsRecipe(Consumer<FinishedRecipe> pWriter, String woodType, int plankNumber) {
        String plankName = woodType + "_planks_" + plankNumber;
        String stairsName = woodType + "_stairs_" + plankNumber;
        BdBlocks.BLOCKS.getEntries().forEach(entry -> {
            Block block = (Block)entry.get();
            if (block.m_5456_().toString().equals(plankName)) {
                Item stairsItem = (Item)BdBlocks.getBlockItemMap().get(stairsName).get();
                Item planksItem = (Item)BdBlocks.getBlockItemMap().get(plankName).get();
                if (block != Blocks.f_50016_ && stairsItem != Items.f_41852_) {
                    ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)stairsItem, (int)4).m_126130_("  0").m_126130_(" 00").m_126130_("000").m_126127_(Character.valueOf('0'), (ItemLike)planksItem).m_126132_("has_planks", (CriterionTriggerInstance)BdRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(BdTags.Items.tag(woodType + "_planks")).m_45077_()})).m_126140_(pWriter, this.getRecipeId(stairsName));
                }
            }
        });
    }

    private void generateSlabRecipe(Consumer<FinishedRecipe> pWriter, String woodType, int plankNumber) {
        String plankName = woodType + "_planks_" + plankNumber;
        String slabName = woodType + "_slab_" + plankNumber;
        BdBlocks.BLOCKS.getEntries().forEach(entry -> {
            Block block = (Block)entry.get();
            if (block.m_5456_().toString().equals(plankName)) {
                Item slabItem = (Item)BdBlocks.getBlockItemMap().get(slabName).get();
                Item planksItem = (Item)BdBlocks.getBlockItemMap().get(plankName).get();
                if (block != Blocks.f_50016_ && slabItem != Items.f_41852_) {
                    ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)slabItem, (int)6).m_126130_("000").m_126127_(Character.valueOf('0'), (ItemLike)planksItem).m_126132_("has_planks", (CriterionTriggerInstance)BdRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(BdTags.Items.tag(woodType + "_planks")).m_45077_()})).m_126140_(pWriter, this.getRecipeId(slabName));
                }
            }
        });
    }

    private void generateGlassRecipe(Consumer<FinishedRecipe> pWriter, String woodType, int number, int plankNumber) {
        String plankName = woodType + "_planks_" + plankNumber;
        String glassName = woodType + "_glass_" + number;
        String glassPaneName = woodType + "_glass_pane_" + number;
        TagKey<Item> woodPlanksTag = this.getWoodPlanksTag(woodType);
        BdBlocks.BLOCKS.getEntries().forEach(entry -> {
            Block block = (Block)entry.get();
            Item glassItem = (Item)BdBlocks.getBlockItemMap().get(glassName).get();
            if (block.m_5456_().toString().equals(plankName) && block != Blocks.f_50016_ && glassItem != Items.f_41852_) {
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)glassItem, (int)8).m_126130_("000").m_126130_("010").m_126130_("000").m_206416_(Character.valueOf('0'), BdTags.Items.tag("glass")).m_206416_(Character.valueOf('1'), woodPlanksTag).m_126132_("has_glass", (CriterionTriggerInstance)BdRecipes.m_206406_((TagKey)Tags.Items.GLASS)).m_126132_("has_glass_colorless", (CriterionTriggerInstance)BdRecipes.m_206406_((TagKey)Tags.Items.GLASS_COLORLESS)).m_126140_(pWriter, this.getRecipeId(glassName));
            }
            if (block.m_5456_().toString().equals(plankName)) {
                Item glassPaneItem = (Item)BdBlocks.getBlockItemMap().get(glassPaneName).get();
                if (block != Blocks.f_50016_ && glassItem != Items.f_41852_) {
                    ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)glassPaneItem, (int)8).m_126130_("000").m_126130_("000").m_126127_(Character.valueOf('0'), (ItemLike)glassItem).m_126132_("has_woodtype_glass", (CriterionTriggerInstance)BdRecipes.m_125977_((ItemLike)glassItem)).m_126140_(pWriter, this.getRecipeId(glassPaneName));
                }
            }
        });
    }

    private TagKey<Item> getWoodPlanksTag(String woodType) {
        return switch (woodType) {
            case "acacia" -> BdTags.Items.tag("acacia_planks");
            case "bamboo" -> BdTags.Items.tag("bamboo_planks");
            case "birch" -> BdTags.Items.tag("birch_planks");
            case "cherry" -> BdTags.Items.tag("cherry_planks");
            case "crimson" -> BdTags.Items.tag("crimson_planks");
            case "dark_oak" -> BdTags.Items.tag("dark_oak_planks");
            case "jungle" -> BdTags.Items.tag("jungle_planks");
            case "mangrove" -> BdTags.Items.tag("mangrove_planks");
            case "oak" -> BdTags.Items.tag("oak_planks");
            case "spruce" -> BdTags.Items.tag("spruce_planks");
            case "warped" -> BdTags.Items.tag("warped_planks");
            default -> null;
        };
    }

    private ResourceLocation getRecipeId(String name) {
        return new ResourceLocation("buildersdelight", name);
    }
}

