/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.datagen;

import com.tynoxs.buildersdelight.datagen.lang.EnglishLangGen;
import com.tynoxs.buildersdelight.datagen.lang.GermanLangGen;
import com.tynoxs.buildersdelight.datagen.providers.BdAdvancementProvider;
import com.tynoxs.buildersdelight.datagen.providers.BdBlockLootTableProvider;
import com.tynoxs.buildersdelight.datagen.providers.BdBlockStateProvider;
import com.tynoxs.buildersdelight.datagen.providers.BdBlockTagProvider;
import com.tynoxs.buildersdelight.datagen.providers.BdItemModelProvider;
import com.tynoxs.buildersdelight.datagen.providers.BdItemTagProvider;
import com.tynoxs.buildersdelight.datagen.providers.BdRecipes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buildersdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BDDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new BdRecipes(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)BdBlockLootTableProvider.create(packOutput));
        BdBlockTagProvider blockTagsProvider = new BdBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new BdItemTagProvider(packOutput, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BdItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BdBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ForgeAdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new BdAdvancementProvider())));
        generator.addProvider(event.includeClient(), (DataProvider)new EnglishLangGen(packOutput, "en_us"));
        generator.addProvider(event.includeClient(), (DataProvider)new GermanLangGen(packOutput, "de_de"));
    }
}

