/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.content.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.tynoxs.buildersdelight.BuildersDelight;
import com.tynoxs.buildersdelight.content.recipe.ChiselRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class ChiselRecipeFactory
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private List<ChiselRecipe> chiselRecipes = new ArrayList<ChiselRecipe>();

    public ChiselRecipeFactory() {
        super(GSON, "chisel");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            try {
                ChiselRecipe recipe = ChiselRecipeFactory.fromJson(resourcelocation, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"));
                if (recipe == null) {
                    LOGGER.info("Skipping loading recipe {} as it's serializer returned null", (Object)resourcelocation);
                    continue;
                }
                this.chiselRecipes.add(recipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
    }

    public List<ChiselRecipe> getChiselRecipes() {
        return this.chiselRecipes;
    }

    public List<ItemStack> getVariants(ItemStack base) {
        for (ChiselRecipe recipe : this.getChiselRecipes()) {
            if (!recipe.contains(base)) continue;
            return recipe.getVariants();
        }
        return new ArrayList<ItemStack>();
    }

    public boolean hasVariants(ItemStack base) {
        return this.getVariants(base) != null;
    }

    public void clear() {
        this.chiselRecipes.clear();
    }

    public static ChiselRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        List<Item> variantsItems = ChiselRecipeFactory.parseVariantsArray(pRecipeId, GsonHelper.m_13933_((JsonObject)pJson, (String)"variants"));
        if (variantsItems == null) {
            return null;
        }
        return ChiselRecipe.newRecipe(variantsItems);
    }

    private static List<Item> parseVariantsArray(ResourceLocation pRecipeId, JsonArray variantsArray) {
        ArrayList<Item> outputItems = new ArrayList<Item>();
        Iterator it = variantsArray.iterator();
        while (it.hasNext()) {
            ResourceLocation variantEntry = ResourceLocation.m_135820_((String)((JsonElement)it.next()).getAsString());
            if (!BuiltInRegistries.f_257033_.m_7804_(variantEntry)) {
                LOGGER.info("Skipping loading recipe {} cause one of it's variant (" + variantEntry + ") doesn't exist", (Object)pRecipeId);
                return null;
            }
            outputItems.add((Item)BuiltInRegistries.f_257033_.m_7745_(variantEntry));
        }
        return outputItems;
    }

    public static ChiselRecipeFactory get() {
        return BuildersDelight.get().getRecipeFactory();
    }
}

