/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.content.block.custom.lantern;

import com.tynoxs.buildersdelight.content.block.custom.lantern.LanternLightable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockCandle
extends LanternLightable {
    protected final ParticleOptions flameParticle;
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    protected static final VoxelShape HANGING = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape STANDING = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    protected static final VoxelShape MOUNTED_NORTH = Block.m_49796_((double)4.0, (double)1.0, (double)6.0, (double)12.0, (double)15.0, (double)16.0);
    protected static final VoxelShape MOUNTED_SOUTH = Block.m_49796_((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)15.0, (double)10.0);
    protected static final VoxelShape MOUNTED_WEST = Block.m_49796_((double)6.0, (double)1.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0);
    protected static final VoxelShape MOUNTED_EAST = Block.m_49796_((double)0.0, (double)1.0, (double)4.0, (double)10.0, (double)15.0, (double)12.0);

    public BlockCandle(BlockBehaviour.Properties properties, ParticleOptions particle) {
        super(properties);
        this.flameParticle = particle;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{FACING, FACE, WATERLOGGED, LIT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidstate = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        for (Direction direction : blockPlaceContext.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag)) : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            if (!blockstate.m_60710_((LevelReader)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        switch ((AttachFace)blockState.m_61143_((Property)FACE)) {
            case FLOOR: {
                return STANDING;
            }
            case WALL: {
                return switch (direction) {
                    case Direction.EAST -> MOUNTED_EAST;
                    case Direction.WEST -> MOUNTED_WEST;
                    case Direction.SOUTH -> MOUNTED_SOUTH;
                    default -> MOUNTED_NORTH;
                };
            }
        }
        return HANGING;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue() && !((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            Direction dir1 = (Direction)stateIn.m_61143_((Property)FACING);
            switch ((AttachFace)stateIn.m_61143_((Property)FACE)) {
                default: {
                    double d0 = (double)pos.m_123341_() + 0.5;
                    double d1 = (double)pos.m_123342_() + 1.01;
                    double d2 = (double)pos.m_123343_() + 0.5;
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                    worldIn.m_7106_(this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
                    break;
                }
                case WALL: {
                    double xo1 = (double)(-dir1.m_122429_()) * 0.11;
                    double zo2 = (double)(-dir1.m_122431_()) * 0.11;
                    double d0 = (double)pos.m_123341_() + 0.5 + xo1;
                    double d1 = (double)pos.m_123342_() + 0.92;
                    double d2 = (double)pos.m_123343_() + 0.5 + zo2;
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                    worldIn.m_7106_(this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
                    break;
                }
                case CEILING: {
                    double d0 = (double)pos.m_123341_() + 0.5;
                    double d1 = (double)pos.m_123342_() + 0.75;
                    double d2 = (double)pos.m_123343_() + 0.15;
                    double d3 = (double)pos.m_123341_() + 0.15;
                    double d4 = (double)pos.m_123343_() + 0.5;
                    double d5 = (double)pos.m_123341_() + 0.85;
                    double d6 = (double)pos.m_123342_() + 0.75;
                    double d7 = (double)pos.m_123343_() + 0.85;
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                    worldIn.m_7106_(this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d3, d1, d4, 0.0, 0.0, 0.0);
                    worldIn.m_7106_(this.flameParticle, d3, d1, d4, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d5, d6, d4, 0.0, 0.0, 0.0);
                    worldIn.m_7106_(this.flameParticle, d5, d6, d4, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d7, 0.0, 0.0, 0.0);
                    worldIn.m_7106_(this.flameParticle, d0, d1, d7, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

